/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.output.v1;

import com.appland.appmap.output.v1.CodeObject;
import com.appland.appmap.output.v1.ExceptionValue;
import com.appland.appmap.output.v1.HttpClientRequest;
import com.appland.appmap.output.v1.HttpClientResponse;
import com.appland.appmap.output.v1.HttpServerRequest;
import com.appland.appmap.output.v1.HttpServerResponse;
import com.appland.appmap.output.v1.Parameters;
import com.appland.appmap.output.v1.SqlQuery;
import com.appland.appmap.output.v1.Value;
import com.appland.shade.com.alibaba.fastjson.annotation.JSONField;
import com.appland.shade.javassist.CtBehavior;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Event {
    private static Integer globalEventId = 0;
    public Integer id;
    public String event;
    public String path;
    public Value receiver;
    public Parameters parameters;
    @JSONField(name="defined_class")
    public String definedClass;
    @JSONField(name="method_id")
    public String methodId;
    @JSONField(name="lineno")
    public Integer lineNumber;
    @JSONField(name="thread_id")
    public Long threadId;
    @JSONField(name="parent_id")
    public Integer parentId;
    @JSONField(name="static")
    public Boolean isStatic;
    @JSONField(name="return_value")
    public Value returnValue;
    public ArrayList<ExceptionValue> exceptions;
    @JSONField(name="http_server_request")
    public HttpServerRequest httpServerRequest;
    @JSONField(name="http_server_response")
    public HttpServerResponse httpServerResponse;
    @JSONField(name="http_client_request")
    public HttpClientRequest httpClientRequest;
    @JSONField(name="http_client_response")
    public HttpClientResponse httpClientResponse;
    public ArrayList<Value> message;
    @JSONField(name="sql_query")
    public SqlQuery sqlQuery;

    private synchronized Integer issueId() {
        globalEventId = globalEventId + 1;
        return globalEventId;
    }

    public Event() {
        this.setId(this.issueId());
    }

    public Event(Event master) {
        this.setId(this.issueId()).setMethodId(master.methodId).setDefinedClass(master.definedClass).setPath(master.path).setLineNumber(master.lineNumber).setStatic(master.isStatic);
    }

    public Event(Method method, String eventType) {
        this.setId(this.issueId()).setMethodId(method.getName()).setDefinedClass(method.getDeclaringClass().getName()).setEvent(eventType).setThreadId(Thread.currentThread().getId());
    }

    public Event(CtBehavior behavior) {
        this.setDefinedClass(behavior.getDeclaringClass().getName()).setMethodId(behavior.getName()).setStatic((behavior.getModifiers() & 8) != 0).setPath(CodeObject.getSourceFilePath(behavior.getDeclaringClass())).setLineNumber(behavior.getMethodInfo().getLineNumber(0)).setParameters(new Parameters(behavior));
    }

    private Event setId(Integer id) {
        this.id = id;
        return this;
    }

    public Event setEvent(String event) {
        this.event = event;
        return this;
    }

    public Event setPath(String path) {
        this.path = path;
        return this;
    }

    public Event setDefinedClass(String definedClass) {
        this.definedClass = definedClass;
        return this;
    }

    public Event setMethodId(String methodId) {
        this.methodId = methodId;
        return this;
    }

    public Event setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    public Event setThreadId(Long threadId) {
        this.threadId = threadId;
        return this;
    }

    public Event setParentId(Integer parentId) {
        this.parentId = parentId;
        return this;
    }

    public Event setStatic(Boolean val) {
        this.isStatic = val;
        return this;
    }

    public Event setReturnValue(Object val) {
        if (val != null) {
            this.returnValue = new Value(val);
        }
        return this;
    }

    public Event setException(Exception exception) {
        if (exception != null) {
            this.exceptions = new ArrayList();
            for (Throwable t = exception; t != null; t = t.getCause()) {
                this.exceptions.add(new ExceptionValue(t));
            }
        }
        return this;
    }

    public Event setReceiver(Object val) {
        if (val != null) {
            this.receiver = new Value(val);
        }
        return this;
    }

    public Event addParameter(Object val, String name) {
        if (this.parameters == null) {
            this.parameters = new Parameters();
        }
        this.parameters.add(new Value(val, name));
        return this;
    }

    public Event addParameter(Value val) {
        if (this.parameters == null) {
            this.parameters = new Parameters();
        }
        this.parameters.add(new Value(val));
        return this;
    }

    public Event setParameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public Event setHttpServerRequest(String method, String path, String protocol) {
        this.httpServerRequest = new HttpServerRequest().setMethod(method).setPath(path).setProtocol(protocol);
        return this;
    }

    public Event setHttpServerResponse(Integer status) {
        this.httpServerResponse = new HttpServerResponse().setStatus(status);
        return this;
    }

    public Event setHttpServerResponse(Integer status, String mimeType) {
        this.httpServerResponse = new HttpServerResponse().setStatus(status).setMimeType(mimeType);
        return this;
    }

    public Event setHttpClientRequest(String method, String path, String protocol) {
        this.httpClientRequest = new HttpClientRequest().setMethod(method).setPath(path).setProtocol(protocol);
        return this;
    }

    public Event setHttpClientResponse(Integer status, String mimeType) {
        this.httpClientResponse = new HttpClientResponse().setStatus(status).setMimeType(mimeType);
        return this;
    }

    public Event addMessageParam(Value val) {
        if (this.message == null) {
            this.message = new ArrayList();
        }
        this.message.add(val);
        return this;
    }

    public Event addMessageParam(String name, Object val) {
        Value valObject = new Value(val, name);
        this.addMessageParam(valObject);
        return this;
    }

    public Event setSqlQuery(String databaseType, String sql) {
        this.sqlQuery = new SqlQuery(databaseType, sql);
        return this;
    }

    public Event freeze() {
        if (this.parameters != null) {
            for (Value value : this.parameters) {
                value.freeze();
            }
        }
        if (this.receiver != null) {
            this.receiver.freeze();
        }
        if (this.returnValue != null) {
            this.returnValue.freeze();
        }
        if (this.exceptions != null) {
            for (ExceptionValue e : this.exceptions) {
                e.freeze();
            }
        }
        return this;
    }
}

