/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;

public class ThreadLock {
    private static final HashMap<Thread, ThreadLock> instances = new HashMap();
    private final Stack<ThreadLockStatus> statusStack = new Stack();

    private ThreadLock() {
    }

    public static ThreadLock current() {
        Thread currentThread = Thread.currentThread();
        ThreadLock instance = null;
        instance = instances.get(currentThread);
        if (instance == null) {
            instance = new ThreadLock();
            instances.put(currentThread, instance);
        }
        return instance;
    }

    public boolean isLocked() {
        for (ThreadLockStatus status : this.statusStack) {
            if (!status.hasGlobalLock()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLock() {
        if (this.statusStack.isEmpty()) {
            return false;
        }
        return this.statusStack.peek().hasGlobalLock();
    }

    public boolean hasUniqueLock(String key) {
        if (this.statusStack.isEmpty()) {
            return false;
        }
        return this.statusStack.peek().contains(key);
    }

    public void enter() {
        this.statusStack.push(new ThreadLockStatus());
    }

    public void exit() {
        if (this.statusStack.isEmpty()) {
            return;
        }
        this.statusStack.pop();
    }

    public boolean lockUnique(String key) {
        if (this.statusStack.isEmpty()) {
            return false;
        }
        for (ThreadLockStatus status : this.statusStack) {
            if (!status.contains(key)) continue;
            return false;
        }
        return this.statusStack.peek().addUniqueKey(key);
    }

    public boolean lock() {
        if (this.isLocked()) {
            return false;
        }
        if (this.statusStack.isEmpty()) {
            return false;
        }
        this.statusStack.peek().setGlobalLock(true);
        return true;
    }

    public boolean unlock() {
        if (this.statusStack.isEmpty()) {
            return false;
        }
        ThreadLockStatus top = this.statusStack.peek();
        if (!top.hasGlobalLock()) {
            return false;
        }
        top.setGlobalLock(false);
        return true;
    }

    private class ThreadLockStatus {
        public Boolean globalLock = false;
        public HashSet<String> uniqueKeys;

        ThreadLockStatus() {
        }

        public boolean addUniqueKey(String key) {
            if (this.uniqueKeys == null) {
                this.uniqueKeys = new HashSet();
            }
            return this.uniqueKeys.add(key);
        }

        public boolean contains(String key) {
            if (this.uniqueKeys == null) {
                return false;
            }
            return this.uniqueKeys.contains(key);
        }

        public boolean hasGlobalLock() {
            return this.globalLock;
        }

        public void setGlobalLock(Boolean globalLock) {
            this.globalLock = globalLock;
        }
    }
}

