/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.ExitEarly;
import com.appland.appmap.process.conditions.RecordCondition;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.IRecordingSession;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.reflect.FilterChain;
import com.appland.appmap.reflect.HttpServletRequest;
import com.appland.appmap.reflect.HttpServletResponse;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.CallbackOn;
import com.appland.appmap.transform.annotations.ContinueHooking;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookAnnotated;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.HookCondition;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.util.Logger;
import com.appland.appmap.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;

public class ToggleRecord {
    private static boolean debug = Properties.DebugHttp;
    private static final Recorder recorder = Recorder.getInstance();
    public static final String RecordRoute = "/_appmap/record";

    private static void doDelete(HttpServletRequest req, HttpServletResponse res) {
        if (debug) {
            Logger.println("ToggleRecord.doDelete");
        }
        try {
            String json = recorder.stop();
            res.setContentType("application/json");
            res.setContentLength(json.length());
            PrintWriter writer = res.getWriter();
            writer.write(json);
            writer.flush();
        }
        catch (ActiveSessionException e) {
            res.setStatus(404);
        }
        catch (IOException e) {
            Logger.printf("failed to write response: %s\n", e.getMessage());
        }
    }

    private static void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (debug) {
            Logger.println("ToggleRecord.doGet");
        }
        res.setStatus(200);
        String responseJson = String.format("{\"enabled\":%b}", recorder.hasActiveSession());
        res.setContentType("application/json");
        res.setContentLength(responseJson.length());
        try {
            PrintWriter writer = res.getWriter();
            writer.write(responseJson);
            writer.flush();
        }
        catch (IOException e) {
            Logger.printf("failed to write response: %s\n", e.getMessage());
        }
    }

    private static void doPost(HttpServletRequest req, HttpServletResponse res) {
        if (debug) {
            Logger.println("ToggleRecord.doPost");
        }
        IRecordingSession.Metadata metadata = new IRecordingSession.Metadata();
        metadata.recorderName = "remote_recording";
        try {
            recorder.start(metadata);
        }
        catch (ActiveSessionException e) {
            res.setStatus(409);
        }
    }

    private static void service(Object[] args) throws ExitEarly {
        if (args.length != 2) {
            return;
        }
        HttpServletRequest req = new HttpServletRequest(args[0]);
        if (!req.getRequestURI().endsWith(RecordRoute)) {
            return;
        }
        if (debug) {
            Logger.println("ToggleRecord.service - handling appmap request");
        }
        HttpServletResponse res = new HttpServletResponse(args[1]);
        if (req.getMethod().equals("GET")) {
            ToggleRecord.doGet(req, res);
        } else if (req.getMethod().equals("POST")) {
            ToggleRecord.doPost(req, res);
        } else if (req.getMethod().equals("DELETE")) {
            ToggleRecord.doDelete(req, res);
        }
        if (debug) {
            Logger.println("ToggleRecord.service - successfully handled appmap request, exiting early");
        }
        throw new ExitEarly();
    }

    private static void skipFilterChain(Object[] args) throws ExitEarly {
        if (args.length != 3) {
            if (debug) {
                Logger.println("ToggleRecord.skipFilterChain - invalid arg length");
            }
            return;
        }
        HttpServletRequest req = new HttpServletRequest(args[0]);
        if (!req.getRequestURI().endsWith(RecordRoute)) {
            return;
        }
        if (debug) {
            Logger.println("ToggleRecord.skipFilterChain - skipping filter chain");
        }
        FilterChain chain = new FilterChain(args[2]);
        chain.doFilter(args[0], args[1]);
        if (debug) {
            Logger.println("ToggleRecord.skipFilterChain - successfully skipped, exiting early");
        }
        throw new ExitEarly();
    }

    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="javax.servlet.http.HttpServlet")
    public static void service(Event event, Object[] args) throws ExitEarly {
        ToggleRecord.service(args);
    }

    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="jakarta.servlet.http.HttpServlet", method="service")
    public static void serviceJakarta(Event event, Object[] args) throws ExitEarly {
        ToggleRecord.service(args);
    }

    @ContinueHooking
    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="javax.servlet.Filter")
    public static void doFilter(Event event, Object[] args) throws ExitEarly {
        ToggleRecord.skipFilterChain(args);
    }

    @ContinueHooking
    @ExcludeReceiver
    @ArgumentArray
    @HookClass(value="jakarta.servlet.Filter", method="doFilter")
    public static void doFilterJakarta(Event event, Object[] args) throws ExitEarly {
        ToggleRecord.skipFilterChain(args);
    }

    private static IRecordingSession.Metadata getMetadata(Event event) {
        boolean junit = false;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 0; !junit && i < stack.length; ++i) {
            if (!stack[i].getClassName().startsWith("com.appland.shade.org.junit")) continue;
            junit = true;
        }
        IRecordingSession.Metadata metadata = new IRecordingSession.Metadata();
        if (junit) {
            metadata.recorderName = "toggle_record_receiver";
            metadata.framework = "junit";
        } else {
            metadata.recorderName = StringUtil.canonicalName(event.definedClass, event.isStatic, event.methodId);
        }
        return metadata;
    }

    private static void startRecording(Event event) {
        try {
            String fileName = String.join((CharSequence)"_", event.definedClass, event.methodId).replaceAll("[^a-zA-Z0-9-_]", "_");
            IRecordingSession.Metadata metadata = ToggleRecord.getMetadata(event);
            metadata.feature = StringUtil.identifierToSentence(event.methodId);
            metadata.featureGroup = StringUtil.identifierToSentence(event.definedClass);
            metadata.scenarioName = String.format("%s %s", metadata.featureGroup, StringUtil.decapitalize(metadata.feature));
            metadata.recordedClassName = event.definedClass;
            metadata.recordedMethodName = event.methodId;
            recorder.start(fileName, metadata);
        }
        catch (ActiveSessionException e) {
            Logger.printf("%s\n", e.getMessage());
        }
    }

    private static void stopRecording() {
        try {
            recorder.stop();
        }
        catch (ActiveSessionException e) {
            Logger.printf("%s\n", e.getMessage());
        }
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="com.appland.shade.org.junit.Test")
    public static void junit(Event event, Object[] args) {
        ToggleRecord.startRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_RETURN)
    @ExcludeReceiver
    @HookAnnotated(value="com.appland.shade.org.junit.Test")
    public static void junit(Event event, Object returnValue, Object[] args) {
        ToggleRecord.stopRecording();
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_EXCEPTION)
    @ExcludeReceiver
    @HookAnnotated(value="com.appland.shade.org.junit.Test")
    public static void junit(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ToggleRecord.stopRecording();
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="com.appland.shade.org.junit.jupiter.api.Test")
    public static void junitJupiter(Event event, Object[] args) {
        ToggleRecord.startRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_RETURN)
    @ExcludeReceiver
    @HookAnnotated(value="com.appland.shade.org.junit.jupiter.api.Test")
    public static void junitJupiter(Event event, Object returnValue, Object[] args) {
        ToggleRecord.stopRecording();
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_EXCEPTION)
    @ExcludeReceiver
    @HookAnnotated(value="com.appland.shade.org.junit.jupiter.api.Test")
    public static void junitJupiter(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ToggleRecord.stopRecording();
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testng(Event event, Object[] args) {
        ToggleRecord.startRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_RETURN)
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testnt(Event event, Object returnValue, Object[] args) {
        ToggleRecord.stopRecording();
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_EXCEPTION)
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testng(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ToggleRecord.stopRecording();
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class)
    public static void record(Event event, Object[] args) {
        Logger.printf("Recording started for %s\n", StringUtil.canonicalName(event));
        ToggleRecord.startRecording(event);
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_RETURN)
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class)
    public static void record(Event event, Object returnValue, Object[] args) {
        ToggleRecord.stopRecording();
    }

    @ArgumentArray
    @CallbackOn(value=MethodEvent.METHOD_EXCEPTION)
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class)
    public static void record(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ToggleRecord.stopRecording();
    }
}

