/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.output.v1.CodeObject;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.output.v1.Value;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.UnknownEventException;
import com.appland.shade.javassist.CtBehavior;
import java.util.Vector;

public class EventTemplateRegistry {
    private static EventTemplateRegistry instance = new EventTemplateRegistry();
    private static final Recorder recorder = Recorder.getInstance();
    private Vector<Event> eventTemplates = new Vector();

    private EventTemplateRegistry() {
    }

    public static EventTemplateRegistry get() {
        return instance;
    }

    public Integer register(CtBehavior behavior) {
        Event event = new Event(behavior);
        return this.register(event, behavior);
    }

    public Integer register(Event event, CtBehavior behavior) {
        recorder.register(CodeObject.createTree(behavior));
        this.eventTemplates.add(event);
        return this.eventTemplates.size() - 1;
    }

    public Event getTemplate(Integer templateId) {
        try {
            return this.eventTemplates.get(templateId);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public Event cloneEventTemplate(int templateId, String eventAction) throws UnknownEventException {
        Event event = null;
        try {
            Event eventTemplate = this.eventTemplates.get(templateId);
            event = new Event(eventTemplate).setThreadId(Thread.currentThread().getId()).setEvent(eventAction);
            if (eventAction.equals("call")) {
                for (Value param : eventTemplate.parameters) {
                    event.addParameter(param);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UnknownEventException(String.format("unknown template for ordinal %d", templateId));
        }
        return event;
    }
}

