/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.output.v1.CodeObject;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.CodeObjectTree;
import com.appland.appmap.record.IRecordingSession;
import com.appland.appmap.record.RecordingSessionFileStream;
import com.appland.appmap.record.RecordingSessionMemory;
import com.appland.appmap.util.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Recorder {
    private static final String ERROR_SESSION_PRESENT = "an active recording session already exists";
    private static final String ERROR_NO_SESSION = "there is no active recording session";
    private IRecordingSession activeSession = null;
    private CodeObjectTree globalCodeObjects = new CodeObjectTree();
    private Map<Long, Event> queuedEvents = new HashMap<Long, Event>();
    private static Recorder instance = new Recorder();

    private Recorder() {
    }

    private synchronized void setActiveSession(IRecordingSession activeSession) throws ActiveSessionException {
        if (this.hasActiveSession().booleanValue()) {
            throw new ActiveSessionException(ERROR_SESSION_PRESENT);
        }
        this.activeSession = activeSession;
        try {
            this.activeSession.start();
        }
        catch (ActiveSessionException e) {
            Logger.printf("failed to start recording", e.getMessage());
            Logger.println(e);
            this.stop();
            throw e;
        }
    }

    public static Recorder getInstance() {
        return instance;
    }

    public synchronized Boolean hasActiveSession() {
        return this.activeSession != null;
    }

    public synchronized IRecordingSession getActiveSession() throws ActiveSessionException {
        if (this.activeSession == null) {
            throw new ActiveSessionException(ERROR_NO_SESSION);
        }
        return this.activeSession;
    }

    public synchronized void start(String fileName, IRecordingSession.Metadata metadata) throws ActiveSessionException {
        this.setActiveSession(new RecordingSessionFileStream(fileName, metadata));
    }

    public synchronized void start(IRecordingSession.Metadata metadata) throws ActiveSessionException {
        this.setActiveSession(new RecordingSessionMemory(metadata));
    }

    private void writeEvent(Event event, IRecordingSession recordingSession) throws ActiveSessionException {
        event.freeze();
        recordingSession.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(IRecordingSession recordingSession) throws ActiveSessionException {
        LinkedList<Event> events;
        Recorder recorder = this;
        synchronized (recorder) {
            events = new LinkedList<Event>(this.queuedEvents.values());
            this.queuedEvents.clear();
        }
        for (Event event : events) {
            this.writeEvent(event, recordingSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEvent(Event event) throws ActiveSessionException {
        Event pendingEvent;
        IRecordingSession recordingSession;
        Recorder recorder = this;
        synchronized (recorder) {
            if (this.activeSession == null) {
                return;
            }
            recordingSession = this.activeSession;
            pendingEvent = this.queuedEvents.get(event.threadId);
            this.queuedEvents.put(event.threadId, event);
        }
        if (pendingEvent != null) {
            this.writeEvent(pendingEvent, recordingSession);
        }
    }

    private synchronized void forceStop() {
        if (this.activeSession == null) {
            return;
        }
        this.activeSession.stop();
        this.activeSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stop() throws ActiveSessionException {
        IRecordingSession recordingSession;
        Recorder recorder = this;
        synchronized (recorder) {
            recordingSession = this.getActiveSession();
            this.activeSession = null;
        }
        try {
            this.flush(recordingSession);
            return recordingSession.stop();
        }
        catch (ActiveSessionException e) {
            Logger.printf("failed to stop recording\n%s\n", e.getMessage());
            this.forceStop();
            return "";
        }
    }

    public void add(Event event) {
        try {
            this.queueEvent(event);
        }
        catch (ActiveSessionException e) {
            Logger.println("failed to record event");
            Logger.println(e);
            this.forceStop();
        }
    }

    public synchronized void register(CodeObject codeObject) {
        this.globalCodeObjects.add(codeObject);
    }

    public CodeObjectTree getRegisteredObjects() {
        return this.globalCodeObjects;
    }

    public synchronized Event getLastEvent() {
        Long threadId = Thread.currentThread().getId();
        return this.queuedEvents.get(threadId);
    }

    public String record(Runnable fn) throws ActiveSessionException {
        this.start(new IRecordingSession.Metadata());
        fn.run();
        return this.stop();
    }

    public void record(String name, Runnable fn) throws ActiveSessionException, IOException {
        String fileName = name.replaceAll("[^a-zA-Z0-9-_]", "_");
        IRecordingSession.Metadata metadata = new IRecordingSession.Metadata();
        metadata.scenarioName = name;
        this.start(fileName, metadata);
        fn.run();
        this.stop();
    }
}

