/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.IRecordingSession;
import com.appland.appmap.record.Recorder;
import com.appland.shade.org.apache.commons.lang3.StringUtils;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Before;
import com.appland.shade.org.junit.Test;

public class RecorderTest {
    @Before
    public void before() throws Exception {
        IRecordingSession.Metadata metadata = new IRecordingSession.Metadata();
        Recorder.getInstance().start(metadata);
    }

    @Test
    public void testAllEventsWritten() {
        Recorder recorder = Recorder.getInstance();
        Long threadId = Thread.currentThread().getId();
        Event[] events = new Event[]{new Event(), new Event(), new Event()};
        for (int i = 0; i < events.length; ++i) {
            Event event = events[i];
            event.setDefinedClass("SomeClass").setMethodId("SomeMethod").setStatic(false).setLineNumber(315).setThreadId(threadId);
            recorder.add(event);
            Assert.assertEquals(event, recorder.getLastEvent());
        }
        String appmapJson = recorder.stop();
        String expectedJson = "\"thread_id\":" + threadId.toString();
        int numMatches = StringUtils.countMatches((CharSequence)appmapJson, expectedJson);
        Assert.assertEquals(numMatches, events.length);
    }
}

