/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.reflect;

import com.appland.appmap.util.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectiveType {
    protected Object self;

    public ReflectiveType(Object self) {
        this.self = self;
    }

    protected Method getMethod(String name, Class<?> ... parameterTypes) {
        Class<?> cls = this.self.getClass();
        try {
            return cls.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            Logger.printf("failed to get method %s.%s: %s\n", cls.getName(), name, e.getMessage());
            return null;
        }
    }

    protected Object invoke(Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            return method.invoke(this.self, parameters);
        }
        catch (InvocationTargetException e) {
            Throwable thrown = e.getTargetException();
            String msg = String.format("%s.%s threw an exception, %s\n", this.self.getClass().getName(), method.getName(), thrown != null ? thrown.getMessage() : "<no msg>");
            Logger.println(msg);
            throw new Error(msg, thrown);
        }
        catch (Exception e) {
            Logger.printf("failed invoking %s.%s, %s\n", this.self.getClass().getName(), method.getName(), e.getMessage());
            return null;
        }
    }

    protected Method getMethodByClassNames(String name, String ... parameterTypes) {
        Method[] methods;
        try {
            methods = this.self.getClass().getMethods();
        }
        catch (Exception e) {
            Logger.printf("failed to get method %s: %s\n", name, e.getMessage());
            return null;
        }
        for (Method method : methods) {
            Class<?>[] methodParamTypes;
            if (!method.getName().equals(name) || (methodParamTypes = method.getParameterTypes()).length != parameterTypes.length) continue;
            boolean match = true;
            for (int i = 0; i < methodParamTypes.length; ++i) {
                String b;
                String a = methodParamTypes[i].getName();
                if (a.equals(b = parameterTypes[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        return null;
    }
}

