/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.test.util;

import com.appland.appmap.test.util.ClassBuilder;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Test;
import java.lang.reflect.Method;

public class AnnotationBuilderTest {
    @Test
    public void testSingleAnnotation() throws Exception {
        Class<?> newClass = new ClassBuilder("AnnotationBuilderTest.testBuild").beginMethod("myMethod").addModifer(1).beginAnnotation(HookClass.class.getName()).setMember("value", "java.sql.Connection").setMember("method", "prepareSQL").endAnnotation().endMethod().build().asClass();
        Method myMethod = newClass.getMethod("myMethod", new Class[0]);
        HookClass annotation = myMethod.getAnnotation(HookClass.class);
        Assert.assertNotNull(annotation);
        Assert.assertEquals("java.sql.Connection", annotation.value());
        Assert.assertEquals("prepareSQL", annotation.method());
    }

    @Test
    public void testManyAnnotations() throws Exception {
        Class<?> newClass = new ClassBuilder("AnnotationBuilderTest.testBuild2").beginMethod("myMethod").addModifer(1).beginAnnotation(HookClass.class.getName()).setMember("value", "java.sql.Connection").setMember("method", "prepareSQL").endAnnotation().addAnnotation(ExcludeReceiver.class.getName()).endMethod().build().asClass();
        Method myMethod = newClass.getMethod("myMethod", new Class[0]);
        HookClass hookAnno = myMethod.getAnnotation(HookClass.class);
        ExcludeReceiver excludeAnno = myMethod.getAnnotation(ExcludeReceiver.class);
        Assert.assertNotNull(hookAnno);
        Assert.assertNotNull(excludeAnno);
        Assert.assertEquals("java.sql.Connection", hookAnno.value());
        Assert.assertEquals("prepareSQL", hookAnno.method());
        Assert.assertTrue(excludeAnno.value());
    }
}

