/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.test.util;

import com.appland.appmap.output.v1.Parameters;
import com.appland.appmap.test.util.ClassBuilder;
import com.appland.appmap.test.util.NewClass;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Rule;
import com.appland.shade.org.junit.Test;
import com.appland.shade.org.junit.contrib.java.lang.system.SystemOutRule;
import java.lang.reflect.Method;

public class MethodBuilderTest {
    @Rule
    public final SystemOutRule systemOutRule = new SystemOutRule().enableLog();
    private static final String myMethodMessage = "calling myMethod";

    @Test
    public void testBuild() throws Exception {
        Class<?> testClass = new ClassBuilder("MethodBuilderTest.testBuild").beginMethod("myMethod").addModifer(1).setBody("{ System.out.println(\"calling myMethod\"); }").endMethod().build().asClass();
        Object obj = testClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method myMethod = testClass.getMethod("myMethod", new Class[0]);
        myMethod.invoke(obj, new Object[0]);
        Assert.assertEquals("calling myMethod\n", this.systemOutRule.getLog());
    }

    @Test
    public void testMultiParameter() throws Exception {
        NewClass testClass = new ClassBuilder("MethodBuilderTest.myMethod").beginMethod("myMethod").addModifer(1).addParameter(CtClass.intType, "x").addParameter(CtClass.doubleType, "y").setBody("{ System.out.println(x + \" \" + y); }").endMethod().build();
        Object obj = testClass.asClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method myMethod = testClass.asClass().getMethod("myMethod", Integer.TYPE, Double.TYPE);
        int x = 100;
        double y = 12.0;
        myMethod.invoke(obj, x, y);
        Assert.assertEquals(x + " " + y + "\n", this.systemOutRule.getLog());
        Assert.assertEquals(2L, myMethod.getParameterCount());
        Assert.assertArrayEquals(new Class[]{Integer.TYPE, Double.TYPE}, myMethod.getParameterTypes());
        testClass.asCtClass().defrost();
        Parameters p = new Parameters(testClass.asCtClass().getDeclaredMethods()[0]);
        Assert.assertEquals("x", p.get((Integer)Integer.valueOf((int)0)).name);
        Assert.assertEquals("y", p.get((Integer)Integer.valueOf((int)1)).name);
    }
}

