/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.test.util;

import com.appland.appmap.test.util.ClassBuilder;
import com.appland.appmap.test.util.MethodBuilder;
import com.appland.appmap.test.util.ParameterBuilder;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Before;
import com.appland.shade.org.junit.Test;

public class ParameterBuilderTest {
    private String paramId = "myParam";
    private CtClass paramType;

    @Before
    public void before() throws Exception {
        this.paramId = "myParam";
        this.paramType = ClassPool.getDefault().get("java.lang.String");
    }

    @Test
    public void testInvalidTypeByName() throws Exception {
        ClassBuilder classBuilder = new ClassBuilder("ParameterBuilderTest.testBuild");
        MethodBuilder methodBuilder = new MethodBuilder(classBuilder);
        ParameterBuilder parameterBuilder = new ParameterBuilder(methodBuilder);
        try {
            parameterBuilder.setType("this is a nonsense string");
        }
        catch (NotFoundException e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testTypeByName() throws Exception {
        ClassBuilder classBuilder = new ClassBuilder("ParameterBuilderTest.testBuild");
        MethodBuilder methodBuilder = new MethodBuilder(classBuilder);
        ParameterBuilder parameterBuilder = new ParameterBuilder(methodBuilder);
        parameterBuilder.setId(this.paramId).setType(this.paramType.getName());
        Assert.assertEquals(this.paramId, parameterBuilder.getId());
        Assert.assertEquals(this.paramType, parameterBuilder.getType());
    }

    void testType() throws Exception {
        ClassBuilder classBuilder = new ClassBuilder("ParameterBuilderTest.testBuild");
        MethodBuilder methodBuilder = new MethodBuilder(classBuilder);
        ParameterBuilder parameterBuilder = new ParameterBuilder(methodBuilder);
        parameterBuilder.setId(this.paramId).setType(this.paramType);
        Assert.assertEquals(this.paramId, parameterBuilder.getId());
        Assert.assertEquals(this.paramType, parameterBuilder.getType());
    }
}

