/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform;

import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.NoSourceAvailableException;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookSite;
import com.appland.appmap.transform.annotations.HookValidationException;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtConstructor;
import com.appland.shade.javassist.LoaderClassPath;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.org.reflections.Reflections;
import com.appland.shade.org.reflections.scanners.SubTypesScanner;
import com.appland.shade.org.reflections.util.ClasspathHelper;
import com.appland.shade.org.reflections.util.ConfigurationBuilder;
import com.appland.shade.org.reflections.util.FilterBuilder;
import java.io.ByteArrayInputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassFileTransformer
implements java.lang.instrument.ClassFileTransformer {
    private static final List<Hook> unkeyedHooks = new ArrayList<Hook>();
    private static final HashMap<String, List<Hook>> keyedHooks = new HashMap();

    public ClassFileTransformer() {
        Reflections reflections = new Reflections(new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage("com.appland.appmap.process", new ClassLoader[0])).setScanners(new SubTypesScanner(false)).filterInputsBy(new FilterBuilder().includePackage("com.appland.appmap.process")));
        ClassPool classPool = ClassPool.getDefault();
        for (Class<Object> classType : reflections.getSubTypesOf(Object.class)) {
            try {
                CtClass ctClass = classPool.get(classType.getName());
                this.processClass(ctClass);
                ctClass.detach();
            }
            catch (NotFoundException e) {
                Logger.printf("failed to find %s in class pool", classType.getName());
                Logger.println(e.getMessage());
            }
        }
    }

    private void addHook(Hook hook) {
        if (hook == null) {
            return;
        }
        String key = hook.getKey();
        if (Properties.DebugHooks.booleanValue()) {
            Logger.printf("%s: %s\n", key, hook);
        }
        if (key == null) {
            unkeyedHooks.add(hook);
        } else {
            List<Hook> matchingKeyedHooks = keyedHooks.get(key);
            if (matchingKeyedHooks == null) {
                matchingKeyedHooks = new ArrayList<Hook>();
                keyedHooks.put(key, matchingKeyedHooks);
            }
            matchingKeyedHooks.add(hook);
        }
    }

    private List<Hook> getHooks(String methodId) {
        List<Hook> matchingKeyedHooks = keyedHooks.get(methodId);
        if (matchingKeyedHooks == null || matchingKeyedHooks.isEmpty()) {
            return unkeyedHooks;
        }
        return Stream.of(matchingKeyedHooks, unkeyedHooks).flatMap(x -> x.stream()).collect(Collectors.toList());
    }

    private void processClass(CtClass ctClass) {
        for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
            Hook hook = Hook.from(behavior);
            if (hook == null) continue;
            ctClass.defrost();
            try {
                hook.validate();
            }
            catch (HookValidationException e) {
                Logger.println("failed to validate hook");
                Logger.println(e.getMessage());
                continue;
            }
            this.addHook(hook);
            if (!Properties.DebugHooks.booleanValue()) continue;
            Logger.printf("registered hook %s\n", hook.toString());
        }
    }

    private void applyHooks(CtBehavior behavior) {
        try {
            List<HookSite> hookSites = this.getHooks(behavior.getName()).stream().map(hook -> hook.prepare(behavior)).filter(Objects::nonNull).collect(Collectors.toList());
            if (hookSites.size() < 1) {
                return;
            }
            Hook.apply(behavior, hookSites);
            if (Properties.DebugHooks.booleanValue()) {
                for (HookSite hookSite : hookSites) {
                    Hook hook2 = hookSite.getHook();
                    Logger.printf("hooked %s.%s%s on (%s) with %s\n", behavior.getDeclaringClass().getName(), behavior.getName(), behavior.getMethodInfo().getDescriptor(), hook2.getMethodEvent().getEventString(), hook2);
                }
            }
        }
        catch (NoSourceAvailableException e) {
            Logger.println(e);
            return;
        }
    }

    public byte[] transform(ClassLoader loader, String className, Class redefiningClass, ProtectionDomain domain, byte[] bytes) throws IllegalClassFormatException {
        ClassPool classPool = new ClassPool(true);
        classPool.appendClassPath(new LoaderClassPath(loader));
        try {
            CtClass ctClass = null;
            try {
                ctClass = classPool.makeClass(new ByteArrayInputStream(bytes));
            }
            catch (RuntimeException e) {
                Logger.printf("Skipping class %s, failed making a new one: %s\n", className, e.getMessage());
                return bytes;
            }
            if (ctClass.isInterface()) {
                return bytes;
            }
            for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
                if (behavior instanceof CtConstructor) continue;
                this.applyHooks(behavior);
            }
            return ctClass.toBytecode();
        }
        catch (Exception e) {
            Logger.println("An error occurred transforming class " + className);
            Logger.println(e.getClass() + ": " + e.getMessage());
            e.printStackTrace(System.err);
            return bytes;
        }
    }
}

