/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.output.v1.Event;
import com.appland.appmap.test.util.ClassBuilder;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ArgumentArraySystem;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookBinding;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Before;
import com.appland.shade.org.junit.Test;
import java.util.ArrayList;

public class ArgumentArraySystemTest {
    private static final String TargetClassName = "ArgumentArraySystemTest.TargetClass";
    private static final String HookClassName = "ArgumentArraySystemTest.HookClass";
    private static final Integer UNUSED_PARAMETER = -1;
    private CtClass targetClass;

    @Before
    public void initializeTestClasses() throws Exception {
        this.targetClass = new ClassBuilder(TargetClassName).beginMethod().setName("methodNoArgs").endMethod().beginMethod().setName("methodSingleArg").beginParameter().setType(CtClass.intType).setId("x").endParameter().endMethod().beginMethod().setName("methodManyArgs").beginParameter().setType(CtClass.intType).setId("x").endParameter().beginParameter().setType(CtClass.intType).setId("y").endParameter().endMethod().ctClass();
    }

    @Test
    public void testValidate() throws Exception {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        ArrayList bindings = new ArrayList();
        CtClass hookClass = new ClassBuilder(HookClassName).beginMethod().setName("methodNoArgs").addParameter(Event.class.getName(), "event").addParameter("java.lang.Object[]", "args").beginAnnotation().setType(HookClass.class.getName()).setMember("value", TargetClassName).endAnnotation().addAnnotation(ArgumentArray.class.getName()).endMethod().beginMethod().setName("methodSingleArg").addParameter(Event.class.getName(), "event").addParameter("java.lang.Object[]", "args").beginAnnotation().setType(HookClass.class.getName()).setMember("value", TargetClassName).endAnnotation().addAnnotation(ArgumentArray.class.getName()).endMethod().beginMethod().setName("methodManyArgs").addParameter(Event.class.getName(), "event").addParameter("java.lang.Object[]", "args").beginAnnotation().setType(HookClass.class.getName()).setMember("value", TargetClassName).endAnnotation().addAnnotation(ArgumentArray.class.getName()).endMethod().ctClass();
        for (CtMethod ctMethod : hookClass.getDeclaredMethods()) {
            Hook hook2 = Hook.from(ctMethod);
            Assert.assertNotNull(hook2);
            hooks.add(hook2);
        }
        for (CtBehavior ctBehavior : this.targetClass.getDeclaredBehaviors()) {
            hooks.stream().filter(hook -> hook.getSourceSystem().match(behavior)).forEach(hook -> bindings.add(new HookBinding((Hook)hook, behavior, UNUSED_PARAMETER)));
        }
        for (HookBinding hookBinding : bindings) {
            Boolean isValid = hookBinding.getHook().getSystem(ArgumentArraySystem.class).validate(hookBinding);
            Assert.assertTrue(isValid);
        }
    }

    @Test
    public void testInvalidHooksFailStaticValidation() throws Exception {
        CtClass hookClass = new ClassBuilder(HookClassName).beginMethod().setName("methodManyArgs").addParameter(Event.class.getName(), "event").addParameter("java.lang.String", "invalidArg").beginAnnotation().setType(HookClass.class.getName()).setMember("value", TargetClassName).endAnnotation().addAnnotation(ArgumentArray.class.getName()).endMethod().ctClass();
        CtMethod invalidHookMethod = hookClass.getDeclaredMethods()[0];
        Assert.assertNull(Hook.from(invalidHookMethod));
    }
}

