/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.transform.annotations.CtClassUtil;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Test;

public class CtClassUtilTest {
    @Test
    public void testChildOfSameClass() throws NotFoundException {
        CtClass candidateChildClass = ClassPool.getDefault().get("java.lang.Object");
        Assert.assertTrue(CtClassUtil.isChildOf(candidateChildClass, "java.lang.Object"));
    }

    @Test
    public void testValidChildOfSuperClass() throws NotFoundException {
        CtClass candidateChildClass = ClassPool.getDefault().get("java.lang.Integer");
        Assert.assertTrue(CtClassUtil.isChildOf(candidateChildClass, "java.lang.Object"));
    }

    @Test
    public void testInvalidChildOfSuperClass() throws NotFoundException {
        CtClass candidateChildClass = ClassPool.getDefault().get("java.lang.Object");
        Assert.assertFalse(CtClassUtil.isChildOf(candidateChildClass, "java.lang.Integer"));
    }

    @Test
    public void testValidChildOfImplementation() throws NotFoundException {
        CtClass candidateChildClass = ClassPool.getDefault().get("java.lang.Throwable");
        Assert.assertTrue(CtClassUtil.isChildOf(candidateChildClass, "java.io.Serializable"));
    }
}

