/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.output.v1.Event;
import com.appland.appmap.test.util.ClassBuilder;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookAnnotated;
import com.appland.appmap.transform.annotations.HookBinding;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Before;
import com.appland.shade.org.junit.Test;
import java.util.ArrayList;

public class HookAnnotatedSystemTest {
    private static final String TargetClassName = "HookAnnotatedSystemTest.TargetClass";
    private static final String HookClassName = "HookAnnotatedSystemTest.HookClass";
    private static final Integer UNUSED_PARAMETER = -1;
    private CtClass targetClass;

    @Before
    public void initializeTestClasses() throws Exception {
        this.targetClass = new ClassBuilder(TargetClassName).beginMethod().setName("methodNoArgs").addAnnotation(Test.class.getName()).endMethod().beginMethod().setName("methodSingleArg").addParameter(CtClass.intType, "x").addAnnotation(Test.class.getName()).endMethod().beginMethod().setName("methodManyArgs").addParameter(CtClass.intType, "x").addParameter(CtClass.intType, "y").addAnnotation(Test.class.getName()).endMethod().ctClass();
    }

    @Test
    public void testValidate() throws Exception {
        ArrayList hooks = new ArrayList();
        ArrayList bindings = new ArrayList();
        CtClass hookClass = new ClassBuilder(HookClassName).beginMethod().setName("methodNoArgs").addParameter(Event.class.getName(), "event").addParameter(TargetClassName, "receiver").beginAnnotation(HookAnnotated.class.getName()).setMember("value", Test.class.getName()).endAnnotation().endMethod().beginMethod().setName("methodSingleArg").addParameter(Event.class.getName(), "event").addParameter(TargetClassName, "receiver").addParameter(CtClass.intType, "x").beginAnnotation(HookAnnotated.class.getName()).setMember("value", Test.class.getName()).endAnnotation().endMethod().beginMethod().setName("methodManyArgs").addParameter(Event.class.getName(), "event").addParameter(TargetClassName, "receiver").addParameter(CtClass.intType, "x").addParameter(CtClass.intType, "y").beginAnnotation(HookAnnotated.class.getName()).setMember("value", Test.class.getName()).endAnnotation().endMethod().ctClass();
        for (CtMethod ctMethod : hookClass.getDeclaredMethods()) {
            Hook hook2 = Hook.from(ctMethod);
            Assert.assertNotNull(hook2);
        }
        for (CtBehavior ctBehavior : this.targetClass.getDeclaredBehaviors()) {
            hooks.stream().filter(hook -> hook.getSourceSystem().match(behavior)).forEach(hook -> bindings.add(new HookBinding((Hook)hook, behavior, UNUSED_PARAMETER)));
        }
        for (HookBinding hookBinding : bindings) {
            Boolean isValid = hookBinding.getHook().getSourceSystem().validate(hookBinding);
            Assert.assertTrue(isValid);
        }
    }
}

