/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.conditions.ConfigCondition;
import com.appland.appmap.test.util.ClassBuilder;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookBinding;
import com.appland.appmap.transform.annotations.HookCondition;
import com.appland.appmap.util.StringUtil;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.org.junit.Assert;
import com.appland.shade.org.junit.Before;
import com.appland.shade.org.junit.Test;
import com.appland.shade.org.mockito.Mockito;
import java.util.ArrayList;

public class HookConditionSystemTest {
    private static final String TargetClassNameGood = "HookConditionSystemTest.Good.TargetClass";
    private static final String TargetClassNameBad = "HookConditionSystemTest.Bad.TargetClass";
    private static final String HookClassName = "HookConditionSystemTest.HookClass";
    private static final Integer UNUSED_PARAMETER = -1;
    private CtClass targetClassGood;
    private CtClass targetClassBad;

    @Before
    public void initializeTestClasses() throws Exception {
        this.targetClassGood = new ClassBuilder(TargetClassNameGood).beginMethod().setName("methodNoArgs").addAnnotation(Test.class.getName()).endMethod().beginMethod().setName("methodSingleArg").addParameter(CtClass.intType, "x").addAnnotation(Test.class.getName()).endMethod().beginMethod().setName("methodManyArgs").addParameter(CtClass.intType, "x").addParameter(CtClass.intType, "y").addAnnotation(Test.class.getName()).endMethod().ctClass();
        this.targetClassBad = new ClassBuilder(TargetClassNameBad).beginMethod().setName("methodNoArgs").addAnnotation(Test.class.getName()).endMethod().beginMethod().setName("methodSingleArg").addParameter(CtClass.intType, "x").addAnnotation(Test.class.getName()).endMethod().beginMethod().setName("methodManyArgs").addParameter(CtClass.intType, "x").addParameter(CtClass.intType, "y").addAnnotation(Test.class.getName()).endMethod().ctClass();
        AppMapConfig config = Mockito.spy(AppMapConfig.get());
        Mockito.doReturn(true).when(config).includes(StringUtil.canonicalName(TargetClassNameGood, false, "methodNoArgs"));
        Mockito.doReturn(true).when(config).includes(StringUtil.canonicalName(TargetClassNameGood, false, "methodSingleArg"));
        Mockito.doReturn(true).when(config).includes(StringUtil.canonicalName(TargetClassNameGood, false, "methodManyArgs"));
    }

    @Test
    public void testValidate() throws Exception {
        ArrayList hooks = new ArrayList();
        ArrayList bindings = new ArrayList();
        CtClass hookClass = new ClassBuilder(HookClassName).beginMethod().setName("methodNoArgs").addParameter(Event.class.getName(), "event").addParameter(TargetClassNameGood, "receiver").beginAnnotation(HookCondition.class.getName()).setMember("value", ConfigCondition.class).endAnnotation().endMethod().beginMethod().setName("methodSingleArg").addParameter(Event.class.getName(), "event").addParameter(TargetClassNameGood, "receiver").addParameter(CtClass.intType, "x").beginAnnotation(HookCondition.class.getName()).setMember("value", ConfigCondition.class).endAnnotation().endMethod().beginMethod().setName("methodManyArgs").addParameter(Event.class.getName(), "event").addParameter(TargetClassNameGood, "receiver").addParameter(CtClass.intType, "x").addParameter(CtClass.intType, "y").beginAnnotation(HookCondition.class.getName()).setMember("value", ConfigCondition.class).endAnnotation().endMethod().ctClass();
        for (CtMethod ctMethod : hookClass.getDeclaredMethods()) {
            Hook hook2 = Hook.from(ctMethod);
            Assert.assertNotNull(hook2);
        }
        for (CtBehavior ctBehavior : this.targetClassGood.getDeclaredBehaviors()) {
            hooks.stream().filter(hook -> hook.getSourceSystem().match(behavior)).forEach(hook -> bindings.add(new HookBinding((Hook)hook, behavior, UNUSED_PARAMETER)));
        }
        for (HookBinding hookBinding : bindings) {
            Boolean isValid = hookBinding.getHook().getSourceSystem().validate(hookBinding);
            Assert.assertTrue(isValid);
        }
    }

    public void testHookFailsCondition() throws Exception {
        ArrayList hooks = new ArrayList();
        ArrayList bindings = new ArrayList();
        CtClass hookClass = new ClassBuilder(HookClassName).beginMethod().setName("methodNoArgs").addParameter(Event.class.getName(), "event").addParameter(TargetClassNameBad, "receiver").beginAnnotation(HookCondition.class.getName()).setMember("value", ConfigCondition.class).endAnnotation().endMethod().beginMethod().setName("methodSingleArg").addParameter(Event.class.getName(), "event").addParameter(TargetClassNameBad, "receiver").addParameter(CtClass.intType, "x").beginAnnotation(HookCondition.class.getName()).setMember("value", ConfigCondition.class).endAnnotation().endMethod().beginMethod().setName("methodManyArgs").addParameter(Event.class.getName(), "event").addParameter(TargetClassNameBad, "receiver").addParameter(CtClass.intType, "x").addParameter(CtClass.intType, "y").beginAnnotation(HookCondition.class.getName()).setMember("value", ConfigCondition.class).endAnnotation().endMethod().ctClass();
        for (CtMethod ctMethod : hookClass.getDeclaredMethods()) {
            Hook hook2 = Hook.from(ctMethod);
            Assert.assertNotNull(hook2);
        }
        for (CtBehavior ctBehavior : this.targetClassBad.getDeclaredBehaviors()) {
            hooks.stream().filter(hook -> hook.getSourceSystem().match(behavior)).forEach(hook -> bindings.add(new HookBinding((Hook)hook, behavior, UNUSED_PARAMETER)));
        }
        for (HookBinding hookBinding : bindings) {
            Boolean isValid = hookBinding.getHook().getSourceSystem().validate(hookBinding);
            Assert.assertFalse(isValid);
        }
    }
}

