/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.output.v1.Parameters;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.ContinueHooking;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.MethodEvent;
import java.util.stream.Collectors;

public class HookSite {
    private final Hook hook;
    private final String hookInvocation;
    private final MethodEvent methodEvent;
    private final Boolean ignoresGlobalLock;

    HookSite(Hook hook, Integer behaviorOrdinal, Parameters parameters) {
        this.methodEvent = hook.getMethodEvent();
        this.hook = hook;
        this.ignoresGlobalLock = (Boolean)AnnotationUtil.getValue(hook.getBehavior(), ContinueHooking.class, false);
        String event = String.format("%s.get().cloneEventTemplate(%d, \"%s\")", "com.appland.appmap.record.EventTemplateRegistry", behaviorOrdinal, this.methodEvent.getEventString());
        String args = parameters.stream().map(param -> param.classType == null || param.classType.isEmpty() ? param.name : String.format("(%s) %s", param.classType, param.name)).collect(Collectors.joining(", ")).replace("$evt", event);
        String invocation = hook.getSourceSystem().toString() + "(" + args + ");";
        if (!this.getUniqueKey().isEmpty()) {
            invocation = "if (com.appland.appmap.process.ThreadLock.current().hasUniqueLock(\"" + this.getUniqueKey() + "\")) {" + invocation + "}";
        }
        this.hookInvocation = this.ignoresGlobalLock() != false ? invocation : "if (com.appland.appmap.process.ThreadLock.current().lock()) {" + invocation + "com.appland.appmap.process.ThreadLock.current().unlock();}";
    }

    public String getHookInvocation() {
        return this.hookInvocation;
    }

    public MethodEvent getMethodEvent() {
        return this.methodEvent;
    }

    public String getUniqueKey() {
        return this.hook.getUniqueKey();
    }

    public Hook getHook() {
        return this.hook;
    }

    public Boolean ignoresGlobalLock() {
        return this.ignoresGlobalLock;
    }
}

