/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.junit.contrib.java.lang.system.internal;

import com.appland.shade.org.junit.contrib.java.lang.system.internal.PrintStreamHandler;
import com.appland.shade.org.junit.runners.model.Statement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class LogPrintStream {
    private final PrintStreamHandler printStreamHandler;
    private final MuteableLogStream muteableLogStream;

    public LogPrintStream(PrintStreamHandler printStreamHandler) {
        this.printStreamHandler = printStreamHandler;
        this.muteableLogStream = new MuteableLogStream(printStreamHandler.getStream());
    }

    public Statement createStatement(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    LogPrintStream.this.printStreamHandler.createRestoreStatement(new Statement(){

                        public void evaluate() throws Throwable {
                            LogPrintStream.this.printStreamHandler.replaceCurrentStreamWithOutputStream(LogPrintStream.this.muteableLogStream);
                            base.evaluate();
                        }
                    }).evaluate();
                }
                catch (Throwable e) {
                    ((LogPrintStream)LogPrintStream.this).muteableLogStream.failureLog.writeTo(LogPrintStream.this.printStreamHandler.getStream());
                    throw e;
                }
            }
        };
    }

    public void clearLog() {
        this.muteableLogStream.log.reset();
    }

    public void enableLog() {
        this.muteableLogStream.logMuted = false;
    }

    public String getLog() {
        String encoding = System.getProperty("file.encoding");
        try {
            return this.muteableLogStream.log.toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLogWithNormalizedLineSeparator() {
        String lineSeparator = System.getProperty("line.separator");
        return this.getLog().replace(lineSeparator, "\n");
    }

    public byte[] getLogAsBytes() {
        return this.muteableLogStream.log.toByteArray();
    }

    public void mute() {
        this.muteableLogStream.originalStreamMuted = true;
    }

    public void muteForSuccessfulTests() {
        this.mute();
        this.muteableLogStream.failureLogMuted = false;
    }

    private static class MuteableLogStream
    extends OutputStream {
        final OutputStream originalStream;
        final ByteArrayOutputStream failureLog = new ByteArrayOutputStream();
        final ByteArrayOutputStream log = new ByteArrayOutputStream();
        boolean originalStreamMuted = false;
        boolean failureLogMuted = true;
        boolean logMuted = true;

        MuteableLogStream(OutputStream originalStream) {
            this.originalStream = originalStream;
        }

        public void write(int b) throws IOException {
            if (!this.originalStreamMuted) {
                this.originalStream.write(b);
            }
            if (!this.failureLogMuted) {
                this.failureLog.write(b);
            }
            if (!this.logMuted) {
                this.log.write(b);
            }
        }

        public void flush() throws IOException {
            this.originalStream.flush();
        }

        public void close() throws IOException {
            this.originalStream.close();
        }
    }
}

