/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.junit.contrib.java.lang.system.internal;

import com.appland.shade.org.junit.runners.model.Statement;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PrintStreamHandler {
    SYSTEM_OUT{

        PrintStream getStream() {
            return System.out;
        }

        void replaceCurrentStreamWithPrintStream(PrintStream stream) {
            System.setOut(stream);
        }
    }
    ,
    SYSTEM_ERR{

        PrintStream getStream() {
            return System.err;
        }

        void replaceCurrentStreamWithPrintStream(PrintStream stream) {
            System.setErr(stream);
        }
    };

    private static final boolean AUTO_FLUSH = true;
    private static final String DEFAULT_ENCODING;

    Statement createRestoreStatement(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                PrintStream originalStream = PrintStreamHandler.this.getStream();
                try {
                    base.evaluate();
                }
                finally {
                    PrintStreamHandler.this.replaceCurrentStreamWithPrintStream(originalStream);
                }
            }
        };
    }

    void replaceCurrentStreamWithOutputStream(OutputStream outputStream) throws UnsupportedEncodingException {
        PrintStream printStream = new PrintStream(outputStream, true, DEFAULT_ENCODING);
        this.replaceCurrentStreamWithPrintStream(printStream);
    }

    abstract PrintStream getStream();

    abstract void replaceCurrentStreamWithPrintStream(PrintStream var1);

    static {
        DEFAULT_ENCODING = Charset.defaultCharset().name();
    }
}

