/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal;

import com.appland.shade.org.mockito.InOrder;
import com.appland.shade.org.mockito.exceptions.base.MockitoException;
import com.appland.shade.org.mockito.internal.MockitoCore;
import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.verification.InOrderContextImpl;
import com.appland.shade.org.mockito.internal.verification.InOrderWrapper;
import com.appland.shade.org.mockito.internal.verification.VerificationModeFactory;
import com.appland.shade.org.mockito.internal.verification.VerificationWrapper;
import com.appland.shade.org.mockito.internal.verification.VerificationWrapperInOrderWrapper;
import com.appland.shade.org.mockito.internal.verification.api.InOrderContext;
import com.appland.shade.org.mockito.internal.verification.api.VerificationInOrderMode;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.verification.VerificationMode;
import java.util.LinkedList;
import java.util.List;

public class InOrderImpl
implements InOrder,
InOrderContext {
    private final MockitoCore mockitoCore = new MockitoCore();
    private final List<Object> mocksToBeVerifiedInOrder = new LinkedList<Object>();
    private final InOrderContext inOrderContext = new InOrderContextImpl();

    public List<Object> getMocksToBeVerifiedInOrder() {
        return this.mocksToBeVerifiedInOrder;
    }

    public InOrderImpl(List<?> mocksToBeVerifiedInOrder) {
        this.mocksToBeVerifiedInOrder.addAll(mocksToBeVerifiedInOrder);
    }

    @Override
    public <T> T verify(T mock) {
        return this.verify(mock, VerificationModeFactory.times(1));
    }

    @Override
    public <T> T verify(T mock, VerificationMode mode) {
        if (!this.mocksToBeVerifiedInOrder.contains(mock)) {
            throw Reporter.inOrderRequiresFamiliarMock();
        }
        if (mode instanceof VerificationWrapper) {
            return this.mockitoCore.verify(mock, new VerificationWrapperInOrderWrapper((VerificationWrapper)mode, this));
        }
        if (!(mode instanceof VerificationInOrderMode)) {
            throw new MockitoException(mode.getClass().getSimpleName() + " is not implemented to work with InOrder");
        }
        return this.mockitoCore.verify(mock, new InOrderWrapper((VerificationInOrderMode)((Object)mode), this));
    }

    @Override
    public boolean isVerified(Invocation i) {
        return this.inOrderContext.isVerified(i);
    }

    @Override
    public void markVerified(Invocation i) {
        this.inOrderContext.markVerified(i);
    }

    @Override
    public void verifyNoMoreInteractions() {
        this.mockitoCore.verifyNoMoreInteractionsInOrder(this.mocksToBeVerifiedInOrder, this);
    }
}

