/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.configuration;

import com.appland.shade.org.mockito.configuration.AnnotationEngine;
import com.appland.shade.org.mockito.configuration.DefaultMockitoConfiguration;
import com.appland.shade.org.mockito.configuration.IMockitoConfiguration;
import com.appland.shade.org.mockito.internal.configuration.ClassPathLoader;
import com.appland.shade.org.mockito.internal.configuration.plugins.Plugins;
import com.appland.shade.org.mockito.stubbing.Answer;
import java.io.Serializable;

public class GlobalConfiguration
implements IMockitoConfiguration,
Serializable {
    private static final long serialVersionUID = -2860353062105505938L;
    private static final ThreadLocal<IMockitoConfiguration> GLOBAL_CONFIGURATION = new ThreadLocal();

    IMockitoConfiguration getIt() {
        return GLOBAL_CONFIGURATION.get();
    }

    public GlobalConfiguration() {
        if (GLOBAL_CONFIGURATION.get() == null) {
            GLOBAL_CONFIGURATION.set(this.createConfig());
        }
    }

    private IMockitoConfiguration createConfig() {
        DefaultMockitoConfiguration defaultConfiguration = new DefaultMockitoConfiguration();
        IMockitoConfiguration config = new ClassPathLoader().loadConfiguration();
        if (config != null) {
            return config;
        }
        return defaultConfiguration;
    }

    public static void validate() {
        new GlobalConfiguration();
    }

    @Override
    public AnnotationEngine getAnnotationEngine() {
        return GLOBAL_CONFIGURATION.get().getAnnotationEngine();
    }

    public com.appland.shade.org.mockito.plugins.AnnotationEngine tryGetPluginAnnotationEngine() {
        IMockitoConfiguration configuration = GLOBAL_CONFIGURATION.get();
        if (configuration.getClass() == DefaultMockitoConfiguration.class) {
            return Plugins.getAnnotationEngine();
        }
        return configuration.getAnnotationEngine();
    }

    @Override
    public boolean cleansStackTrace() {
        return GLOBAL_CONFIGURATION.get().cleansStackTrace();
    }

    @Override
    public boolean enableClassCache() {
        return GLOBAL_CONFIGURATION.get().enableClassCache();
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return GLOBAL_CONFIGURATION.get().getDefaultAnswer();
    }
}

