/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.configuration;

import com.appland.shade.org.mockito.configuration.AnnotationEngine;
import com.appland.shade.org.mockito.internal.configuration.DefaultInjectionEngine;
import com.appland.shade.org.mockito.internal.configuration.IndependentAnnotationEngine;
import com.appland.shade.org.mockito.internal.configuration.SpyAnnotationEngine;
import com.appland.shade.org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import com.appland.shade.org.mockito.internal.configuration.injection.scanner.MockScanner;
import com.appland.shade.org.mockito.internal.util.collections.Sets;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

public class InjectingAnnotationEngine
implements com.appland.shade.org.mockito.plugins.AnnotationEngine,
AnnotationEngine {
    private final com.appland.shade.org.mockito.plugins.AnnotationEngine delegate = new IndependentAnnotationEngine();
    private final com.appland.shade.org.mockito.plugins.AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    public void process(Class<?> clazz, Object testInstance) {
        this.processIndependentAnnotations(testInstance.getClass(), testInstance);
        this.injectMocks(testInstance);
    }

    private void processIndependentAnnotations(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.delegate.process(classContext, testInstance);
            this.spyAnnotationEngine.process(classContext, testInstance);
        }
    }

    public void injectMocks(Object testClassInstance) {
        HashSet<Field> mockDependentFields = new HashSet<Field>();
        Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        for (Class<?> clazz = testClassInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            new InjectMocksScanner(clazz).addTo(mockDependentFields);
            new MockScanner(testClassInstance, clazz).addPreparedMocks(mocks);
            this.onInjection(testClassInstance, clazz, mockDependentFields, mocks);
        }
        new DefaultInjectionEngine().injectMocksOnFields(mockDependentFields, mocks, testClassInstance);
    }

    protected void onInjection(Object testClassInstance, Class<?> clazz, Set<Field> mockDependentFields, Set<Object> mocks) {
    }
}

