/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.configuration.injection;

import com.appland.shade.org.mockito.exceptions.base.MockitoException;
import com.appland.shade.org.mockito.internal.configuration.injection.MockInjectionStrategy;
import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.util.reflection.FieldInitializationReport;
import com.appland.shade.org.mockito.internal.util.reflection.FieldInitializer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Set;

public class ConstructorInjection
extends MockInjectionStrategy {
    @Override
    public boolean processInjection(Field field, Object fieldOwner, Set<Object> mockCandidates) {
        try {
            SimpleArgumentResolver simpleArgumentResolver = new SimpleArgumentResolver(mockCandidates);
            FieldInitializationReport report = new FieldInitializer(fieldOwner, field, simpleArgumentResolver).initialize();
            return report.fieldWasInitializedUsingContructorArgs();
        }
        catch (MockitoException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                Throwable realCause = e.getCause().getCause();
                throw Reporter.fieldInitialisationThrewException(field, realCause);
            }
            return false;
        }
    }

    static class SimpleArgumentResolver
    implements FieldInitializer.ConstructorArgumentResolver {
        final Set<Object> objects;

        public SimpleArgumentResolver(Set<Object> objects) {
            this.objects = objects;
        }

        @Override
        public Object[] resolveTypeInstances(Class<?> ... argTypes) {
            ArrayList<Object> argumentInstances = new ArrayList<Object>(argTypes.length);
            for (Class<?> argType : argTypes) {
                argumentInstances.add(this.objectThatIsAssignableFrom(argType));
            }
            return argumentInstances.toArray();
        }

        private Object objectThatIsAssignableFrom(Class<?> argType) {
            for (Object object : this.objects) {
                if (!argType.isAssignableFrom(object.getClass())) continue;
                return object;
            }
            return null;
        }
    }
}

