/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.configuration.injection;

import com.appland.shade.org.mockito.Mockito;
import com.appland.shade.org.mockito.Spy;
import com.appland.shade.org.mockito.exceptions.base.MockitoException;
import com.appland.shade.org.mockito.internal.configuration.injection.MockInjectionStrategy;
import com.appland.shade.org.mockito.internal.util.MockUtil;
import com.appland.shade.org.mockito.internal.util.reflection.FieldReader;
import com.appland.shade.org.mockito.internal.util.reflection.FieldSetter;
import java.lang.reflect.Field;
import java.util.Set;

public class SpyOnInjectedFieldsHandler
extends MockInjectionStrategy {
    @Override
    protected boolean processInjection(Field field, Object fieldOwner, Set<Object> mockCandidates) {
        FieldReader fieldReader = new FieldReader(fieldOwner, field);
        if (!fieldReader.isNull() && field.isAnnotationPresent(Spy.class)) {
            try {
                Object instance = fieldReader.read();
                if (MockUtil.isMock(instance)) {
                    Mockito.reset(instance);
                } else {
                    Object mock = Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName()));
                    FieldSetter.setField(fieldOwner, field, mock);
                }
            }
            catch (Exception e) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), e);
            }
        }
        return false;
    }
}

