/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.configuration.injection.filter;

import com.appland.shade.org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import com.appland.shade.org.mockito.internal.configuration.injection.filter.OngoingInjector;
import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.util.reflection.BeanPropertySetter;
import com.appland.shade.org.mockito.internal.util.reflection.FieldSetter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class TerminalMockCandidateFilter
implements MockCandidateFilter {
    @Override
    public OngoingInjector filterCandidate(Collection<Object> mocks, final Field candidateFieldToBeInjected, List<Field> allRemainingCandidateFields, final Object injectee) {
        if (mocks.size() == 1) {
            final Object matchingMock = mocks.iterator().next();
            return new OngoingInjector(){

                @Override
                public Object thenInject() {
                    try {
                        if (!new BeanPropertySetter(injectee, candidateFieldToBeInjected).set(matchingMock)) {
                            FieldSetter.setField(injectee, candidateFieldToBeInjected, matchingMock);
                        }
                    }
                    catch (RuntimeException e) {
                        throw Reporter.cannotInjectDependency(candidateFieldToBeInjected, matchingMock, e);
                    }
                    return matchingMock;
                }
            };
        }
        return OngoingInjector.nop;
    }
}

