/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.configuration.injection.scanner;

import com.appland.shade.org.mockito.Captor;
import com.appland.shade.org.mockito.InjectMocks;
import com.appland.shade.org.mockito.Mock;
import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

public class InjectMocksScanner {
    private final Class<?> clazz;

    public InjectMocksScanner(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void addTo(Set<Field> mockDependentFields) {
        mockDependentFields.addAll(this.scan());
    }

    private Set<Field> scan() {
        Field[] fields;
        HashSet<Field> mockDependentFields = new HashSet<Field>();
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            if (null == field.getAnnotation(InjectMocks.class)) continue;
            InjectMocksScanner.assertNoAnnotations(field, Mock.class, Captor.class);
            mockDependentFields.add(field);
        }
        return mockDependentFields;
    }

    private static void assertNoAnnotations(Field field, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!field.isAnnotationPresent(annotation)) continue;
            throw Reporter.unsupportedCombinationOfAnnotations(annotation.getSimpleName(), InjectMocks.class.getSimpleName());
        }
    }
}

