/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.configuration.injection.scanner;

import com.appland.shade.org.mockito.Mock;
import com.appland.shade.org.mockito.Spy;
import com.appland.shade.org.mockito.internal.util.MockUtil;
import com.appland.shade.org.mockito.internal.util.collections.Sets;
import com.appland.shade.org.mockito.internal.util.reflection.FieldReader;
import java.lang.reflect.Field;
import java.util.Set;

public class MockScanner {
    private final Object instance;
    private final Class<?> clazz;

    public MockScanner(Object instance, Class<?> clazz) {
        this.instance = instance;
        this.clazz = clazz;
    }

    public void addPreparedMocks(Set<Object> mocks) {
        mocks.addAll(this.scan());
    }

    private Set<Object> scan() {
        Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        for (Field field : this.clazz.getDeclaredFields()) {
            FieldReader fieldReader = new FieldReader(this.instance, field);
            Object mockInstance = this.preparedMock(fieldReader.read(), field);
            if (mockInstance == null) continue;
            mocks.add(mockInstance);
        }
        return mocks;
    }

    private Object preparedMock(Object instance, Field field) {
        if (this.isAnnotatedByMockOrSpy(field)) {
            return instance;
        }
        if (this.isMockOrSpy(instance)) {
            MockUtil.maybeRedefineMockName(instance, field.getName());
            return instance;
        }
        return null;
    }

    private boolean isAnnotatedByMockOrSpy(Field field) {
        return field.isAnnotationPresent(Spy.class) || field.isAnnotationPresent(Mock.class);
    }

    private boolean isMockOrSpy(Object instance) {
        return MockUtil.isMock(instance) || MockUtil.isSpy(instance);
    }
}

