/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.configuration.plugins;

import com.appland.shade.org.mockito.exceptions.base.MockitoException;
import com.appland.shade.org.mockito.internal.configuration.plugins.PluginFileReader;
import com.appland.shade.org.mockito.internal.util.io.IOUtil;
import com.appland.shade.org.mockito.plugins.PluginSwitch;
import java.io.InputStream;
import java.net.URL;

class PluginFinder {
    private final PluginSwitch pluginSwitch;

    public PluginFinder(PluginSwitch pluginSwitch) {
        this.pluginSwitch = pluginSwitch;
    }

    String findPluginClass(Iterable<URL> resources) {
        for (URL resource : resources) {
            InputStream s = null;
            try {
                s = resource.openStream();
                String pluginClassName = new PluginFileReader().readPluginClass(s);
                if (pluginClassName == null || !this.pluginSwitch.isEnabled(pluginClassName)) continue;
                String string = pluginClassName;
                return string;
            }
            catch (Exception e) {
                throw new MockitoException("Problems reading plugin implementation from: " + resource, e);
            }
            finally {
                IOUtil.closeQuietly(s);
            }
        }
        return null;
    }
}

