/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.exceptions.stacktrace;

import com.appland.shade.org.mockito.exceptions.stacktrace.StackTraceCleaner;
import com.appland.shade.org.mockito.internal.configuration.plugins.Plugins;
import com.appland.shade.org.mockito.internal.exceptions.stacktrace.DefaultStackTraceCleaner;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class StackTraceFilter
implements Serializable {
    static final long serialVersionUID = -5499819791513105700L;
    private static final StackTraceCleaner CLEANER = Plugins.getStackTraceCleanerProvider().getStackTraceCleaner(new DefaultStackTraceCleaner());
    private static Object JAVA_LANG_ACCESS;
    private static Method GET_STACK_TRACE_ELEMENT;

    public StackTraceElement[] filter(StackTraceElement[] target, boolean keepTop) {
        ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : target) {
            if (!CLEANER.isIn(element)) continue;
            filtered.add(element);
        }
        StackTraceElement[] result = new StackTraceElement[filtered.size()];
        return filtered.toArray(result);
    }

    public StackTraceElement filterFirst(Throwable target, boolean isInline) {
        boolean shouldSkip = isInline;
        if (GET_STACK_TRACE_ELEMENT != null) {
            int i = 0;
            while (true) {
                block7: {
                    try {
                        StackTraceElement stackTraceElement = (StackTraceElement)GET_STACK_TRACE_ELEMENT.invoke(JAVA_LANG_ACCESS, target, i);
                        if (!CLEANER.isIn(stackTraceElement)) break block7;
                        if (shouldSkip) {
                            shouldSkip = false;
                            break block7;
                        }
                        return stackTraceElement;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                ++i;
            }
        }
        for (StackTraceElement stackTraceElement : target.getStackTrace()) {
            if (!CLEANER.isIn(stackTraceElement)) continue;
            if (shouldSkip) {
                shouldSkip = false;
                continue;
            }
            return stackTraceElement;
        }
        return null;
    }

    public String findSourceFile(StackTraceElement[] target, String defaultValue) {
        for (StackTraceElement e : target) {
            if (!CLEANER.isIn(e)) continue;
            return e.getFileName();
        }
        return defaultValue;
    }

    static {
        try {
            JAVA_LANG_ACCESS = Class.forName("sun.misc.SharedSecrets").getMethod("getJavaLangAccess", new Class[0]).invoke(null, new Object[0]);
            GET_STACK_TRACE_ELEMENT = Class.forName("sun.misc.JavaLangAccess").getMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

