/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.framework;

import com.appland.shade.org.mockito.MockitoFramework;
import com.appland.shade.org.mockito.internal.configuration.plugins.Plugins;
import com.appland.shade.org.mockito.internal.invocation.DefaultInvocationFactory;
import com.appland.shade.org.mockito.internal.progress.ThreadSafeMockingProgress;
import com.appland.shade.org.mockito.internal.util.Checks;
import com.appland.shade.org.mockito.invocation.InvocationFactory;
import com.appland.shade.org.mockito.listeners.MockitoListener;
import com.appland.shade.org.mockito.plugins.InlineMockMaker;
import com.appland.shade.org.mockito.plugins.MockMaker;
import com.appland.shade.org.mockito.plugins.MockitoPlugins;

public class DefaultMockitoFramework
implements MockitoFramework {
    @Override
    public MockitoFramework addListener(MockitoListener listener) {
        Checks.checkNotNull(listener, "listener");
        ThreadSafeMockingProgress.mockingProgress().addListener(listener);
        return this;
    }

    @Override
    public MockitoFramework removeListener(MockitoListener listener) {
        Checks.checkNotNull(listener, "listener");
        ThreadSafeMockingProgress.mockingProgress().removeListener(listener);
        return this;
    }

    @Override
    public MockitoPlugins getPlugins() {
        return Plugins.getPlugins();
    }

    @Override
    public InvocationFactory getInvocationFactory() {
        return new DefaultInvocationFactory();
    }

    private InlineMockMaker getInlineMockMaker() {
        MockMaker mockMaker = Plugins.getMockMaker();
        return mockMaker instanceof InlineMockMaker ? (InlineMockMaker)mockMaker : null;
    }

    @Override
    public void clearInlineMocks() {
        InlineMockMaker mockMaker = this.getInlineMockMaker();
        if (mockMaker != null) {
            mockMaker.clearAllMocks();
        }
    }

    @Override
    public void clearInlineMock(Object mock) {
        InlineMockMaker mockMaker = this.getInlineMockMaker();
        if (mockMaker != null) {
            mockMaker.clearMock(mock);
        }
    }
}

