/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.framework;

import com.appland.shade.org.mockito.Mockito;
import com.appland.shade.org.mockito.MockitoAnnotations;
import com.appland.shade.org.mockito.MockitoSession;
import com.appland.shade.org.mockito.exceptions.misusing.RedundantListenerException;
import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.junit.TestFinishedEvent;
import com.appland.shade.org.mockito.internal.junit.UniversalTestListener;
import com.appland.shade.org.mockito.plugins.MockitoLogger;
import com.appland.shade.org.mockito.quality.Strictness;
import java.util.List;

public class DefaultMockitoSession
implements MockitoSession {
    private final String name;
    private final UniversalTestListener listener;

    public DefaultMockitoSession(List<Object> testClassInstances, String name, Strictness strictness, MockitoLogger logger) {
        this.name = name;
        this.listener = new UniversalTestListener(strictness, logger);
        try {
            Mockito.framework().addListener(this.listener);
        }
        catch (RedundantListenerException e) {
            Reporter.unfinishedMockingSession();
        }
        try {
            for (Object testClassInstance : testClassInstances) {
                MockitoAnnotations.initMocks(testClassInstance);
            }
        }
        catch (RuntimeException e) {
            this.listener.setListenerDirty();
            throw e;
        }
    }

    @Override
    public void setStrictness(Strictness strictness) {
        this.listener.setStrictness(strictness);
    }

    @Override
    public void finishMocking() {
        this.finishMocking(null);
    }

    @Override
    public void finishMocking(final Throwable failure) {
        Mockito.framework().removeListener(this.listener);
        this.listener.testFinished(new TestFinishedEvent(){

            @Override
            public Throwable getFailure() {
                return failure;
            }

            @Override
            public String getTestName() {
                return DefaultMockitoSession.this.name;
            }
        });
        if (failure == null) {
            Mockito.validateMockitoUsage();
        }
    }
}

