/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.handler;

import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.handler.NotifiedMethodInvocationReport;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.InvocationContainer;
import com.appland.shade.org.mockito.invocation.MockHandler;
import com.appland.shade.org.mockito.listeners.InvocationListener;
import com.appland.shade.org.mockito.mock.MockCreationSettings;
import java.util.List;

class InvocationNotifierHandler<T>
implements MockHandler<T> {
    private final List<InvocationListener> invocationListeners;
    private final MockHandler<T> mockHandler;

    public InvocationNotifierHandler(MockHandler<T> mockHandler, MockCreationSettings<T> settings) {
        this.mockHandler = mockHandler;
        this.invocationListeners = settings.getInvocationListeners();
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        try {
            Object returnedValue = this.mockHandler.handle(invocation);
            this.notifyMethodCall(invocation, returnedValue);
            return returnedValue;
        }
        catch (Throwable t) {
            this.notifyMethodCallException(invocation, t);
            throw t;
        }
    }

    private void notifyMethodCall(Invocation invocation, Object returnValue) {
        for (InvocationListener listener : this.invocationListeners) {
            try {
                listener.reportInvocation(new NotifiedMethodInvocationReport(invocation, returnValue));
            }
            catch (Throwable listenerThrowable) {
                throw Reporter.invocationListenerThrewException(listener, listenerThrowable);
            }
        }
    }

    private void notifyMethodCallException(Invocation invocation, Throwable exception) {
        for (InvocationListener listener : this.invocationListeners) {
            try {
                listener.reportInvocation(new NotifiedMethodInvocationReport(invocation, exception));
            }
            catch (Throwable listenerThrowable) {
                throw Reporter.invocationListenerThrewException(listener, listenerThrowable);
            }
        }
    }

    @Override
    public MockCreationSettings<T> getMockSettings() {
        return this.mockHandler.getMockSettings();
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.mockHandler.getInvocationContainer();
    }
}

