/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.handler;

import com.appland.shade.org.mockito.internal.creation.settings.CreationSettings;
import com.appland.shade.org.mockito.internal.invocation.InvocationMatcher;
import com.appland.shade.org.mockito.internal.invocation.MatchersBinder;
import com.appland.shade.org.mockito.internal.listeners.StubbingLookupNotifier;
import com.appland.shade.org.mockito.internal.progress.ThreadSafeMockingProgress;
import com.appland.shade.org.mockito.internal.stubbing.InvocationContainerImpl;
import com.appland.shade.org.mockito.internal.stubbing.OngoingStubbingImpl;
import com.appland.shade.org.mockito.internal.stubbing.StubbedInvocationMatcher;
import com.appland.shade.org.mockito.internal.stubbing.answers.DefaultAnswerValidator;
import com.appland.shade.org.mockito.internal.verification.MockAwareVerificationMode;
import com.appland.shade.org.mockito.internal.verification.VerificationDataImpl;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.InvocationContainer;
import com.appland.shade.org.mockito.invocation.MockHandler;
import com.appland.shade.org.mockito.mock.MockCreationSettings;
import com.appland.shade.org.mockito.verification.VerificationMode;

public class MockHandlerImpl<T>
implements MockHandler<T> {
    private static final long serialVersionUID = -2917871070982574165L;
    InvocationContainerImpl invocationContainer;
    MatchersBinder matchersBinder = new MatchersBinder();
    private final MockCreationSettings<T> mockSettings;

    public MockHandlerImpl(MockCreationSettings<T> mockSettings) {
        this.mockSettings = mockSettings;
        this.matchersBinder = new MatchersBinder();
        this.invocationContainer = new InvocationContainerImpl(mockSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handle(Invocation invocation) throws Throwable {
        if (this.invocationContainer.hasAnswersForStubbing()) {
            InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage(), invocation);
            this.invocationContainer.setMethodForStubbing(invocationMatcher);
            return null;
        }
        VerificationMode verificationMode = ThreadSafeMockingProgress.mockingProgress().pullVerificationMode();
        InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage(), invocation);
        ThreadSafeMockingProgress.mockingProgress().validateState();
        if (verificationMode != null) {
            if (((MockAwareVerificationMode)verificationMode).getMock() == invocation.getMock()) {
                VerificationDataImpl data = new VerificationDataImpl(this.invocationContainer, invocationMatcher);
                verificationMode.verify(data);
                return null;
            }
            ThreadSafeMockingProgress.mockingProgress().verificationStarted(verificationMode);
        }
        this.invocationContainer.setInvocationForPotentialStubbing(invocationMatcher);
        OngoingStubbingImpl ongoingStubbing = new OngoingStubbingImpl(this.invocationContainer);
        ThreadSafeMockingProgress.mockingProgress().reportOngoingStubbing(ongoingStubbing);
        StubbedInvocationMatcher stubbing = this.invocationContainer.findAnswerFor(invocation);
        StubbingLookupNotifier.notifyStubbedAnswerLookup(invocation, stubbing, this.invocationContainer.getStubbingsAscending(), (CreationSettings)this.mockSettings);
        if (stubbing != null) {
            stubbing.captureArgumentsFrom(invocation);
            try {
                Object object = stubbing.answer(invocation);
                return object;
            }
            finally {
                ThreadSafeMockingProgress.mockingProgress().reportOngoingStubbing(ongoingStubbing);
            }
        }
        Object ret = this.mockSettings.getDefaultAnswer().answer(invocation);
        DefaultAnswerValidator.validateReturnValueFor(invocation, ret);
        this.invocationContainer.resetInvocationForPotentialStubbing(invocationMatcher);
        return ret;
    }

    @Override
    public MockCreationSettings<T> getMockSettings() {
        return this.mockSettings;
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.invocationContainer;
    }
}

