/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.handler;

import com.appland.shade.org.mockito.internal.util.Primitives;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.InvocationContainer;
import com.appland.shade.org.mockito.invocation.MockHandler;
import com.appland.shade.org.mockito.mock.MockCreationSettings;

class NullResultGuardian<T>
implements MockHandler<T> {
    private final MockHandler<T> delegate;

    public NullResultGuardian(MockHandler<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        Object result = this.delegate.handle(invocation);
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (result == null && returnType.isPrimitive()) {
            return Primitives.defaultValue(returnType);
        }
        return result;
    }

    @Override
    public MockCreationSettings<T> getMockSettings() {
        return this.delegate.getMockSettings();
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.delegate.getInvocationContainer();
    }
}

