/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.invocation;

import com.appland.shade.org.mockito.ArgumentMatcher;
import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.invocation.InvocationMatcher;
import com.appland.shade.org.mockito.internal.matchers.LocalizedMatcher;
import com.appland.shade.org.mockito.internal.progress.ArgumentMatcherStorage;
import com.appland.shade.org.mockito.invocation.Invocation;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class MatchersBinder
implements Serializable {
    public InvocationMatcher bindMatchers(ArgumentMatcherStorage argumentMatcherStorage, Invocation invocation) {
        List<LocalizedMatcher> lastMatchers = argumentMatcherStorage.pullLocalizedMatchers();
        this.validateMatchers(invocation, lastMatchers);
        LinkedList<ArgumentMatcher> matchers = new LinkedList<ArgumentMatcher>();
        for (LocalizedMatcher m : lastMatchers) {
            matchers.add(m.getMatcher());
        }
        return new InvocationMatcher(invocation, matchers);
    }

    private void validateMatchers(Invocation invocation, List<LocalizedMatcher> lastMatchers) {
        if (!lastMatchers.isEmpty()) {
            int recordedMatchersSize = lastMatchers.size();
            int expectedMatchersSize = invocation.getArguments().length;
            if (expectedMatchersSize != recordedMatchersSize) {
                throw Reporter.invalidUseOfMatchers(expectedMatchersSize, lastMatchers);
            }
        }
    }
}

