/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.junit;

import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.stubbing.StrictnessSelector;
import com.appland.shade.org.mockito.internal.stubbing.UnusedStubbingReporting;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.listeners.StubbingLookupEvent;
import com.appland.shade.org.mockito.listeners.StubbingLookupListener;
import com.appland.shade.org.mockito.quality.Strictness;
import com.appland.shade.org.mockito.stubbing.Stubbing;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class DefaultStubbingLookupListener
implements StubbingLookupListener,
Serializable {
    private static final long serialVersionUID = -6789800638070123629L;
    private Strictness currentStrictness;
    private boolean mismatchesReported;

    DefaultStubbingLookupListener(Strictness strictness) {
        this.currentStrictness = strictness;
    }

    @Override
    public void onStubbingLookup(StubbingLookupEvent event) {
        Strictness actualStrictness = StrictnessSelector.determineStrictness(event.getStubbingFound(), event.getMockSettings(), this.currentStrictness);
        if (actualStrictness != Strictness.STRICT_STUBS) {
            return;
        }
        if (event.getStubbingFound() == null) {
            List<Invocation> argMismatchStubbings = DefaultStubbingLookupListener.potentialArgMismatches(event.getInvocation(), event.getAllStubbings());
            if (!argMismatchStubbings.isEmpty()) {
                this.mismatchesReported = true;
                Reporter.potentialStubbingProblem(event.getInvocation(), argMismatchStubbings);
            }
        } else {
            event.getInvocation().markVerified();
        }
    }

    private static List<Invocation> potentialArgMismatches(Invocation invocation, Collection<Stubbing> stubbings) {
        LinkedList<Invocation> matchingStubbings = new LinkedList<Invocation>();
        for (Stubbing s : stubbings) {
            if (!UnusedStubbingReporting.shouldBeReported(s) || !s.getInvocation().getMethod().getName().equals(invocation.getMethod().getName()) || s.getInvocation().getLocation().getSourceFile().equals(invocation.getLocation().getSourceFile())) continue;
            matchingStubbings.add(s.getInvocation());
        }
        return matchingStubbings;
    }

    void setCurrentStrictness(Strictness currentStrictness) {
        this.currentStrictness = currentStrictness;
    }

    boolean isMismatchesReported() {
        return this.mismatchesReported;
    }
}

