/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.junit;

import com.appland.shade.org.mockito.internal.creation.settings.CreationSettings;
import com.appland.shade.org.mockito.internal.junit.ArgMismatchFinder;
import com.appland.shade.org.mockito.internal.junit.DefaultStubbingLookupListener;
import com.appland.shade.org.mockito.internal.junit.MockitoTestListener;
import com.appland.shade.org.mockito.internal.junit.TestFinishedEvent;
import com.appland.shade.org.mockito.internal.junit.UnusedStubbings;
import com.appland.shade.org.mockito.internal.junit.UnusedStubbingsFinder;
import com.appland.shade.org.mockito.internal.listeners.AutoCleanableListener;
import com.appland.shade.org.mockito.mock.MockCreationSettings;
import com.appland.shade.org.mockito.plugins.MockitoLogger;
import com.appland.shade.org.mockito.quality.Strictness;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class UniversalTestListener
implements MockitoTestListener,
AutoCleanableListener {
    private Strictness currentStrictness;
    private final MockitoLogger logger;
    private Map<Object, MockCreationSettings> mocks = new IdentityHashMap<Object, MockCreationSettings>();
    private DefaultStubbingLookupListener stubbingLookupListener;
    private boolean listenerDirty;

    public UniversalTestListener(Strictness initialStrictness, MockitoLogger logger) {
        this.currentStrictness = initialStrictness;
        this.logger = logger;
        this.stubbingLookupListener = new DefaultStubbingLookupListener(this.currentStrictness);
    }

    @Override
    public void testFinished(TestFinishedEvent event) {
        Set<Object> createdMocks = this.mocks.keySet();
        this.mocks = new IdentityHashMap<Object, MockCreationSettings>();
        switch (this.currentStrictness) {
            case WARN: {
                UniversalTestListener.emitWarnings(this.logger, event, createdMocks);
                break;
            }
            case STRICT_STUBS: {
                this.reportUnusedStubs(event, createdMocks);
                break;
            }
            case LENIENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown strictness: " + (Object)((Object)this.currentStrictness));
            }
        }
    }

    private void reportUnusedStubs(TestFinishedEvent event, Collection<Object> mocks) {
        if (event.getFailure() == null && !this.stubbingLookupListener.isMismatchesReported()) {
            UnusedStubbings unused = new UnusedStubbingsFinder().getUnusedStubbings(mocks);
            unused.reportUnused();
        }
    }

    private static void emitWarnings(MockitoLogger logger, TestFinishedEvent event, Collection<Object> mocks) {
        if (event.getFailure() != null) {
            new ArgMismatchFinder().getStubbingArgMismatches(mocks).format(event.getTestName(), logger);
        } else {
            new UnusedStubbingsFinder().getUnusedStubbings(mocks).format(event.getTestName(), logger);
        }
    }

    @Override
    public void onMockCreated(Object mock, MockCreationSettings settings) {
        this.mocks.put(mock, settings);
        ((CreationSettings)settings).getStubbingLookupListeners().add(this.stubbingLookupListener);
    }

    public void setStrictness(Strictness strictness) {
        this.currentStrictness = strictness;
        this.stubbingLookupListener.setCurrentStrictness(strictness);
    }

    @Override
    public boolean isListenerDirty() {
        return this.listenerDirty;
    }

    public void setListenerDirty() {
        this.listenerDirty = true;
    }
}

