/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.junit;

import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.junit.StubbingHint;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.plugins.MockitoLogger;
import com.appland.shade.org.mockito.stubbing.Stubbing;
import java.util.Collection;
import java.util.LinkedList;

public class UnusedStubbings {
    private final Collection<? extends Stubbing> unused;

    UnusedStubbings(Collection<? extends Stubbing> unused) {
        this.unused = unused;
    }

    void format(String testName, MockitoLogger logger) {
        if (this.unused.isEmpty()) {
            return;
        }
        StubbingHint hint = new StubbingHint(testName);
        int x = 1;
        for (Stubbing stubbing : this.unused) {
            if (stubbing.wasUsed()) continue;
            hint.appendLine(x++, ". Unused ", stubbing.getInvocation().getLocation());
        }
        logger.log(hint.toString());
    }

    public int size() {
        return this.unused.size();
    }

    public String toString() {
        return this.unused.toString();
    }

    void reportUnused() {
        if (this.unused.isEmpty()) {
            return;
        }
        LinkedList<Invocation> invocations = new LinkedList<Invocation>();
        for (Stubbing stubbing : this.unused) {
            invocations.add(stubbing.getInvocation());
        }
        if (invocations.isEmpty()) {
            return;
        }
        Reporter.unncessaryStubbingException(invocations);
    }
}

