/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.matchers;

import com.appland.shade.org.mockito.ArgumentMatcher;
import com.appland.shade.org.mockito.internal.matchers.ContainsExtraTypeInfo;
import com.appland.shade.org.mockito.internal.matchers.Equality;
import com.appland.shade.org.mockito.internal.matchers.text.ValuePrinter;
import java.io.Serializable;

public class Equals
implements ArgumentMatcher<Object>,
ContainsExtraTypeInfo,
Serializable {
    private final Object wanted;

    public Equals(Object wanted) {
        this.wanted = wanted;
    }

    @Override
    public boolean matches(Object actual) {
        return Equality.areEqual(this.wanted, actual);
    }

    public String toString() {
        return this.describe(this.wanted);
    }

    private String describe(Object object) {
        return ValuePrinter.print(object);
    }

    protected final Object getWanted() {
        return this.wanted;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Equals other = (Equals)o;
        return this.wanted == null && other.wanted == null || this.wanted != null && this.wanted.equals(other.wanted);
    }

    public int hashCode() {
        return 1;
    }

    @Override
    public String toStringWithType() {
        return "(" + this.wanted.getClass().getSimpleName() + ") " + this.describe(this.wanted);
    }

    @Override
    public boolean typeMatches(Object target) {
        return this.wanted != null && target != null && target.getClass() == this.wanted.getClass();
    }
}

