/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.session;

import com.appland.shade.org.mockito.MockitoSession;
import com.appland.shade.org.mockito.internal.configuration.plugins.Plugins;
import com.appland.shade.org.mockito.internal.framework.DefaultMockitoSession;
import com.appland.shade.org.mockito.internal.session.MockitoLoggerAdapter;
import com.appland.shade.org.mockito.plugins.MockitoLogger;
import com.appland.shade.org.mockito.quality.Strictness;
import com.appland.shade.org.mockito.session.MockitoSessionBuilder;
import com.appland.shade.org.mockito.session.MockitoSessionLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultMockitoSessionBuilder
implements MockitoSessionBuilder {
    private List<Object> testClassInstances = new ArrayList<Object>();
    private String name;
    private Strictness strictness;
    private MockitoSessionLogger logger;

    @Override
    public MockitoSessionBuilder initMocks(Object testClassInstance) {
        if (testClassInstance != null) {
            this.testClassInstances.add(testClassInstance);
        }
        return this;
    }

    @Override
    public MockitoSessionBuilder initMocks(Object ... testClassInstances) {
        if (testClassInstances != null) {
            for (Object instance : testClassInstances) {
                this.initMocks(instance);
            }
        }
        return this;
    }

    @Override
    public MockitoSessionBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MockitoSessionBuilder strictness(Strictness strictness) {
        this.strictness = strictness;
        return this;
    }

    @Override
    public MockitoSessionBuilder logger(MockitoSessionLogger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public MockitoSession startMocking() {
        String effectiveName;
        List<Object> effectiveTestClassInstances;
        if (this.testClassInstances.isEmpty()) {
            effectiveTestClassInstances = Collections.emptyList();
            effectiveName = this.name == null ? "<Unnamed Session>" : this.name;
        } else {
            effectiveTestClassInstances = new ArrayList<Object>(this.testClassInstances);
            Object lastTestClassInstance = this.testClassInstances.get(this.testClassInstances.size() - 1);
            effectiveName = this.name == null ? lastTestClassInstance.getClass().getName() : this.name;
        }
        Strictness effectiveStrictness = this.strictness == null ? Strictness.STRICT_STUBS : this.strictness;
        MockitoLogger logger = this.logger == null ? Plugins.getMockitoLogger() : new MockitoLoggerAdapter(this.logger);
        return new DefaultMockitoSession(effectiveTestClassInstances, effectiveName, effectiveStrictness, logger);
    }
}

