/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.stubbing;

import com.appland.shade.org.mockito.internal.invocation.StubInfoImpl;
import com.appland.shade.org.mockito.internal.progress.ThreadSafeMockingProgress;
import com.appland.shade.org.mockito.internal.stubbing.DoAnswerStyleStubbing;
import com.appland.shade.org.mockito.internal.stubbing.StubbedInvocationMatcher;
import com.appland.shade.org.mockito.internal.verification.DefaultRegisteredInvocations;
import com.appland.shade.org.mockito.internal.verification.RegisteredInvocations;
import com.appland.shade.org.mockito.internal.verification.SingleRegisteredInvocation;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.InvocationContainer;
import com.appland.shade.org.mockito.invocation.MatchableInvocation;
import com.appland.shade.org.mockito.mock.MockCreationSettings;
import com.appland.shade.org.mockito.quality.Strictness;
import com.appland.shade.org.mockito.stubbing.Answer;
import com.appland.shade.org.mockito.stubbing.Stubbing;
import com.appland.shade.org.mockito.stubbing.ValidableAnswer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class InvocationContainerImpl
implements InvocationContainer,
Serializable {
    private static final long serialVersionUID = -5334301962749537177L;
    private final LinkedList<StubbedInvocationMatcher> stubbed = new LinkedList();
    private final DoAnswerStyleStubbing doAnswerStyleStubbing;
    private final RegisteredInvocations registeredInvocations;
    private final Strictness mockStrictness;
    private MatchableInvocation invocationForStubbing;

    public InvocationContainerImpl(MockCreationSettings mockSettings) {
        this.registeredInvocations = this.createRegisteredInvocations(mockSettings);
        this.mockStrictness = mockSettings.isLenient() ? Strictness.LENIENT : null;
        this.doAnswerStyleStubbing = new DoAnswerStyleStubbing();
    }

    public void setInvocationForPotentialStubbing(MatchableInvocation invocation) {
        this.registeredInvocations.add(invocation.getInvocation());
        this.invocationForStubbing = invocation;
    }

    public void resetInvocationForPotentialStubbing(MatchableInvocation invocationMatcher) {
        this.invocationForStubbing = invocationMatcher;
    }

    public void addAnswer(Answer answer, Strictness stubbingStrictness) {
        this.registeredInvocations.removeLast();
        this.addAnswer(answer, false, stubbingStrictness);
    }

    public void addConsecutiveAnswer(Answer answer) {
        this.addAnswer(answer, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubbedInvocationMatcher addAnswer(Answer answer, boolean isConsecutive, Strictness stubbingStrictness) {
        Invocation invocation = this.invocationForStubbing.getInvocation();
        ThreadSafeMockingProgress.mockingProgress().stubbingCompleted();
        if (answer instanceof ValidableAnswer) {
            ((ValidableAnswer)((Object)answer)).validateFor(invocation);
        }
        LinkedList<StubbedInvocationMatcher> linkedList = this.stubbed;
        synchronized (linkedList) {
            if (isConsecutive) {
                this.stubbed.getFirst().addAnswer(answer);
            } else {
                Strictness effectiveStrictness = stubbingStrictness != null ? stubbingStrictness : this.mockStrictness;
                this.stubbed.addFirst(new StubbedInvocationMatcher(answer, this.invocationForStubbing, effectiveStrictness));
            }
            return this.stubbed.getFirst();
        }
    }

    Object answerTo(Invocation invocation) throws Throwable {
        return this.findAnswerFor(invocation).answer(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubbedInvocationMatcher findAnswerFor(Invocation invocation) {
        LinkedList<StubbedInvocationMatcher> linkedList = this.stubbed;
        synchronized (linkedList) {
            for (StubbedInvocationMatcher s : this.stubbed) {
                if (!s.matches(invocation)) continue;
                s.markStubUsed(invocation);
                invocation.markStubbed(new StubInfoImpl(s));
                return s;
            }
        }
        return null;
    }

    public void setAnswersForStubbing(List<Answer<?>> answers, Strictness strictness) {
        this.doAnswerStyleStubbing.setAnswers(answers, strictness);
    }

    public boolean hasAnswersForStubbing() {
        return !this.doAnswerStyleStubbing.isSet();
    }

    public boolean hasInvocationForPotentialStubbing() {
        return !this.registeredInvocations.isEmpty();
    }

    public void setMethodForStubbing(MatchableInvocation invocation) {
        this.invocationForStubbing = invocation;
        assert (this.hasAnswersForStubbing());
        for (int i = 0; i < this.doAnswerStyleStubbing.getAnswers().size(); ++i) {
            this.addAnswer(this.doAnswerStyleStubbing.getAnswers().get(i), i != 0, this.doAnswerStyleStubbing.getStubbingStrictness());
        }
        this.doAnswerStyleStubbing.clear();
    }

    public String toString() {
        return "invocationForStubbing: " + this.invocationForStubbing;
    }

    public List<Invocation> getInvocations() {
        return this.registeredInvocations.getAll();
    }

    public void clearInvocations() {
        this.registeredInvocations.clear();
    }

    public List<Stubbing> getStubbingsDescending() {
        return this.stubbed;
    }

    public Collection<Stubbing> getStubbingsAscending() {
        LinkedList<Stubbing> result = new LinkedList<Stubbing>(this.stubbed);
        Collections.reverse(result);
        return result;
    }

    public Object invokedMock() {
        return this.invocationForStubbing.getInvocation().getMock();
    }

    public MatchableInvocation getInvocationForStubbing() {
        return this.invocationForStubbing;
    }

    private RegisteredInvocations createRegisteredInvocations(MockCreationSettings mockSettings) {
        return mockSettings.isStubOnly() ? new SingleRegisteredInvocation() : new DefaultRegisteredInvocations();
    }
}

