/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.stubbing.answers;

import com.appland.shade.org.mockito.internal.invocation.AbstractAwareMethod;
import com.appland.shade.org.mockito.internal.util.MockUtil;
import com.appland.shade.org.mockito.internal.util.Primitives;
import com.appland.shade.org.mockito.internal.util.reflection.GenericMetadataSupport;
import com.appland.shade.org.mockito.invocation.InvocationOnMock;
import com.appland.shade.org.mockito.mock.MockCreationSettings;
import java.lang.reflect.Method;

public class InvocationInfo
implements AbstractAwareMethod {
    private final Method method;
    private final InvocationOnMock invocation;

    public InvocationInfo(InvocationOnMock theInvocation) {
        this.method = theInvocation.getMethod();
        this.invocation = theInvocation;
    }

    public boolean isValidException(Throwable throwable) {
        Class<?>[] exceptions = this.method.getExceptionTypes();
        Class<?> throwableClass = throwable.getClass();
        for (Class<?> exception : exceptions) {
            if (!exception.isAssignableFrom(throwableClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidReturnType(Class<?> clazz) {
        if (this.method.getReturnType().isPrimitive() || clazz.isPrimitive()) {
            return Primitives.primitiveTypeOf(clazz) == Primitives.primitiveTypeOf(this.method.getReturnType());
        }
        return this.method.getReturnType().isAssignableFrom(clazz);
    }

    public boolean isVoid() {
        MockCreationSettings<Object> mockSettings = MockUtil.getMockHandler(this.invocation.getMock()).getMockSettings();
        Class<?> returnType = GenericMetadataSupport.inferFrom(mockSettings.getTypeToMock()).resolveGenericReturnType(this.method).rawType();
        return returnType == Void.TYPE || returnType == Void.class;
    }

    public String printMethodReturnType() {
        return this.method.getReturnType().getSimpleName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public boolean returnsPrimitive() {
        return this.method.getReturnType().isPrimitive();
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isDeclaredOnInterface() {
        return this.method.getDeclaringClass().isInterface();
    }

    @Override
    public boolean isAbstract() {
        return (this.method.getModifiers() & 0x400) != 0;
    }
}

