/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.stubbing.answers;

import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import com.appland.shade.org.mockito.internal.stubbing.answers.InvocationInfo;
import com.appland.shade.org.mockito.internal.util.MockUtil;
import com.appland.shade.org.mockito.invocation.InvocationOnMock;
import com.appland.shade.org.mockito.stubbing.Answer;
import com.appland.shade.org.mockito.stubbing.ValidableAnswer;
import java.io.Serializable;

public class ThrowsException
implements Answer<Object>,
ValidableAnswer,
Serializable {
    private static final long serialVersionUID = 1128820328555183980L;
    private final Throwable throwable;
    private final ConditionalStackTraceFilter filter = new ConditionalStackTraceFilter();

    public ThrowsException(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        if (this.throwable == null) {
            throw new IllegalStateException("throwable is null: you shall not call #answer if #validateFor fails!");
        }
        if (MockUtil.isMock(this.throwable)) {
            throw this.throwable;
        }
        Throwable t = this.throwable.fillInStackTrace();
        if (t == null) {
            throw this.throwable;
        }
        this.filter.filter(t);
        throw t;
    }

    @Override
    public void validateFor(InvocationOnMock invocation) {
        if (this.throwable == null) {
            throw Reporter.cannotStubWithNullThrowable();
        }
        if (this.throwable instanceof RuntimeException || this.throwable instanceof Error) {
            return;
        }
        if (!new InvocationInfo(invocation).isValidException(this.throwable)) {
            throw Reporter.checkedExceptionInvalid(this.throwable);
        }
    }
}

