/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.stubbing.defaultanswers;

import com.appland.shade.org.mockito.Mockito;
import com.appland.shade.org.mockito.internal.debugging.LocationImpl;
import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.stubbing.defaultanswers.RetrieveGenericsForDefaultAnswers;
import com.appland.shade.org.mockito.internal.stubbing.defaultanswers.ReturnsMoreEmptyValues;
import com.appland.shade.org.mockito.internal.util.ObjectMethodsGuru;
import com.appland.shade.org.mockito.invocation.InvocationOnMock;
import com.appland.shade.org.mockito.invocation.Location;
import com.appland.shade.org.mockito.stubbing.Answer;
import java.io.Serializable;

public class ReturnsSmartNulls
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 7618312406617949441L;
    private final Answer<Object> delegate = new ReturnsMoreEmptyValues();

    @Override
    public Object answer(final InvocationOnMock invocation) throws Throwable {
        Object defaultReturnValue = this.delegate.answer(invocation);
        if (defaultReturnValue != null) {
            return defaultReturnValue;
        }
        return RetrieveGenericsForDefaultAnswers.returnTypeForMockWithCorrectGenerics(invocation, new RetrieveGenericsForDefaultAnswers.AnswerCallback(){

            @Override
            public Object apply(Class<?> type) {
                if (type == null) {
                    return null;
                }
                return Mockito.mock(type, new ThrowsSmartNullPointer(invocation, new LocationImpl()));
            }
        });
    }

    private static class ThrowsSmartNullPointer
    implements Answer {
        private final InvocationOnMock unstubbedInvocation;
        private final Location location;

        ThrowsSmartNullPointer(InvocationOnMock unstubbedInvocation, Location location) {
            this.unstubbedInvocation = unstubbedInvocation;
            this.location = location;
        }

        public Object answer(InvocationOnMock currentInvocation) throws Throwable {
            if (ObjectMethodsGuru.isToStringMethod(currentInvocation.getMethod())) {
                return "SmartNull returned by this unstubbed method call on a mock:\n" + this.unstubbedInvocation.toString();
            }
            throw Reporter.smartNullPointerException(this.unstubbedInvocation.toString(), this.location);
        }
    }
}

