/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.util;

public class Checks {
    public static <T> T checkNotNull(T value, String checkedValue) {
        return Checks.checkNotNull(value, checkedValue, null);
    }

    public static <T> T checkNotNull(T value, String checkedValue, String additionalMessage) {
        if (value == null) {
            String message = checkedValue + " should not be null";
            if (additionalMessage != null) {
                message = message + ". " + additionalMessage;
            }
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Iterable<?>> T checkItemsNotNull(T iterable, String checkedIterable) {
        Checks.checkNotNull(iterable, checkedIterable);
        for (Object item : iterable) {
            Checks.checkNotNull(item, "item in " + checkedIterable);
        }
        return iterable;
    }
}

