/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.util;

import com.appland.shade.org.mockito.MockingDetails;
import com.appland.shade.org.mockito.exceptions.misusing.NotAMockException;
import com.appland.shade.org.mockito.internal.debugging.InvocationsPrinter;
import com.appland.shade.org.mockito.internal.stubbing.InvocationContainerImpl;
import com.appland.shade.org.mockito.internal.util.MockUtil;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.MockHandler;
import com.appland.shade.org.mockito.mock.MockCreationSettings;
import com.appland.shade.org.mockito.stubbing.Stubbing;
import java.util.Collection;

public class DefaultMockingDetails
implements MockingDetails {
    private final Object toInspect;

    public DefaultMockingDetails(Object toInspect) {
        this.toInspect = toInspect;
    }

    @Override
    public boolean isMock() {
        return MockUtil.isMock(this.toInspect);
    }

    @Override
    public boolean isSpy() {
        return MockUtil.isSpy(this.toInspect);
    }

    @Override
    public Collection<Invocation> getInvocations() {
        return this.getInvocationContainer().getInvocations();
    }

    private InvocationContainerImpl getInvocationContainer() {
        this.assertGoodMock();
        return MockUtil.getInvocationContainer(this.toInspect);
    }

    @Override
    public MockCreationSettings<?> getMockCreationSettings() {
        return this.mockHandler().getMockSettings();
    }

    @Override
    public Collection<Stubbing> getStubbings() {
        return this.getInvocationContainer().getStubbingsAscending();
    }

    @Override
    public String printInvocations() {
        this.assertGoodMock();
        return new InvocationsPrinter().printInvocations(this.toInspect);
    }

    @Override
    public MockHandler getMockHandler() {
        return this.mockHandler();
    }

    @Override
    public Object getMock() {
        return this.toInspect;
    }

    private MockHandler<Object> mockHandler() {
        this.assertGoodMock();
        return MockUtil.getMockHandler(this.toInspect);
    }

    private void assertGoodMock() {
        if (this.toInspect == null) {
            throw new NotAMockException("Argument passed to Mockito.mockingDetails() should be a mock, but is null!");
        }
        if (!this.isMock()) {
            throw new NotAMockException("Argument passed to Mockito.mockingDetails() should be a mock, but is an instance of " + this.toInspect.getClass() + "!");
        }
    }
}

