/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.util.collections;

import com.appland.shade.org.mockito.internal.util.Checks;
import com.appland.shade.org.mockito.internal.util.collections.HashCodeAndEqualsMockWrapper;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HashCodeAndEqualsSafeSet
implements Set<Object> {
    private final HashSet<HashCodeAndEqualsMockWrapper> backingHashSet = new HashSet();

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private final Iterator<HashCodeAndEqualsMockWrapper> iterator;
            {
                this.iterator = HashCodeAndEqualsSafeSet.this.backingHashSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Object next() {
                return this.iterator.next().get();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.backingHashSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingHashSet.isEmpty();
    }

    @Override
    public boolean contains(Object mock) {
        return this.backingHashSet.contains(HashCodeAndEqualsMockWrapper.of(mock));
    }

    @Override
    public boolean add(Object mock) {
        return this.backingHashSet.add(HashCodeAndEqualsMockWrapper.of(mock));
    }

    @Override
    public boolean remove(Object mock) {
        return this.backingHashSet.remove(HashCodeAndEqualsMockWrapper.of(mock));
    }

    @Override
    public void clear() {
        this.backingHashSet.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HashCodeAndEqualsSafeSet)) {
            return false;
        }
        HashCodeAndEqualsSafeSet that = (HashCodeAndEqualsSafeSet)o;
        return this.backingHashSet.equals(that.backingHashSet);
    }

    @Override
    public int hashCode() {
        return this.backingHashSet.hashCode();
    }

    @Override
    public Object[] toArray() {
        return this.unwrapTo(new Object[this.size()]);
    }

    private <T> T[] unwrapTo(T[] array) {
        Iterator<Object> iterator = this.iterator();
        int objectsLength = array.length;
        for (int i = 0; i < objectsLength; ++i) {
            if (!iterator.hasNext()) continue;
            array[i] = iterator.next();
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] typedArray) {
        T[] array = typedArray.length >= this.size() ? typedArray : (Object[])Array.newInstance(typedArray.getClass().getComponentType(), this.size());
        return this.unwrapTo(array);
    }

    @Override
    public boolean removeAll(Collection<?> mocks) {
        return this.backingHashSet.removeAll(this.asWrappedMocks(mocks));
    }

    @Override
    public boolean containsAll(Collection<?> mocks) {
        return this.backingHashSet.containsAll(this.asWrappedMocks(mocks));
    }

    @Override
    public boolean addAll(Collection<?> mocks) {
        return this.backingHashSet.addAll(this.asWrappedMocks(mocks));
    }

    @Override
    public boolean retainAll(Collection<?> mocks) {
        return this.backingHashSet.retainAll(this.asWrappedMocks(mocks));
    }

    private HashSet<HashCodeAndEqualsMockWrapper> asWrappedMocks(Collection<?> mocks) {
        Checks.checkNotNull(mocks, "Passed collection should notify() be null");
        HashSet<HashCodeAndEqualsMockWrapper> hashSet = new HashSet<HashCodeAndEqualsMockWrapper>();
        for (Object mock : mocks) {
            assert (!(mock instanceof HashCodeAndEqualsMockWrapper)) : "WRONG";
            hashSet.add(HashCodeAndEqualsMockWrapper.of(mock));
        }
        return hashSet;
    }

    public String toString() {
        return this.backingHashSet.toString();
    }

    public static HashCodeAndEqualsSafeSet of(Object ... mocks) {
        return HashCodeAndEqualsSafeSet.of(Arrays.asList(mocks));
    }

    public static HashCodeAndEqualsSafeSet of(Iterable<Object> objects) {
        HashCodeAndEqualsSafeSet hashCodeAndEqualsSafeSet = new HashCodeAndEqualsSafeSet();
        if (objects != null) {
            for (Object mock : objects) {
                hashCodeAndEqualsSafeSet.add(mock);
            }
        }
        return hashCodeAndEqualsSafeSet;
    }
}

