/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.util.reflection;

import com.appland.shade.org.mockito.internal.util.reflection.AccessibilityChanger;
import java.lang.reflect.Field;

public class FieldSetter {
    private FieldSetter() {
    }

    public static void setField(Object target, Field field, Object value) {
        AccessibilityChanger changer = new AccessibilityChanger();
        changer.enableAccess(field);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access not authorized on field '" + field + "' of object '" + target + "' with value: '" + value + "'", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Wrong argument on field '" + field + "' of object '" + target + "' with value: '" + value + "', \nreason : " + e.getMessage(), e);
        }
        changer.safelyDisableAccess(field);
    }
}

