/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.util.reflection;

import com.appland.shade.org.mockito.exceptions.base.MockitoException;
import com.appland.shade.org.mockito.internal.util.Checks;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class GenericMetadataSupport {
    protected Map<TypeVariable<?>, Type> contextualActualTypeParameters = new HashMap();

    protected void registerAllTypeVariables(Type classType) {
        LinkedList<Type> typesToRegister = new LinkedList<Type>();
        HashSet<Type> registeredTypes = new HashSet<Type>();
        typesToRegister.add(classType);
        while (!typesToRegister.isEmpty()) {
            Type typeToRegister = (Type)typesToRegister.poll();
            if (typeToRegister == null || registeredTypes.contains(typeToRegister)) continue;
            this.registerTypeVariablesOn(typeToRegister);
            registeredTypes.add(typeToRegister);
            Class<?> rawType = this.extractRawTypeOf(typeToRegister);
            typesToRegister.add(rawType.getGenericSuperclass());
            typesToRegister.addAll(Arrays.asList(rawType.getGenericInterfaces()));
        }
    }

    protected Class<?> extractRawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof BoundedType) {
            return this.extractRawTypeOf(((BoundedType)type).firstBound());
        }
        if (type instanceof TypeVariable) {
            return this.extractRawTypeOf(this.contextualActualTypeParameters.get(type));
        }
        throw new MockitoException("Raw extraction not supported for : '" + type + "'");
    }

    protected void registerTypeVariablesOn(Type classType) {
        if (!(classType instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)classType;
        TypeVariable<Class<T>>[] typeParameters = ((Class)parameterizedType.getRawType()).getTypeParameters();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            TypeVariable typeParameter = typeParameters[i];
            Type actualTypeArgument = actualTypeArguments[i];
            if (actualTypeArgument instanceof TypeVariable) {
                this.registerTypeVariableIfNotPresent((TypeVariable)actualTypeArgument);
                if (this.contextualActualTypeParameters.containsKey(typeParameter)) continue;
            }
            if (actualTypeArgument instanceof WildcardType) {
                this.contextualActualTypeParameters.put(typeParameter, this.boundsOf((WildcardType)actualTypeArgument));
                continue;
            }
            if (typeParameter == actualTypeArgument) continue;
            this.contextualActualTypeParameters.put(typeParameter, actualTypeArgument);
        }
    }

    protected void registerTypeParametersOn(TypeVariable<?>[] typeParameters) {
        for (TypeVariable<?> type : typeParameters) {
            this.registerTypeVariableIfNotPresent(type);
        }
    }

    private void registerTypeVariableIfNotPresent(TypeVariable<?> typeVariable) {
        if (!this.contextualActualTypeParameters.containsKey(typeVariable)) {
            this.contextualActualTypeParameters.put(typeVariable, this.boundsOf(typeVariable));
        }
    }

    private BoundedType boundsOf(TypeVariable<?> typeParameter) {
        if (typeParameter.getBounds()[0] instanceof TypeVariable) {
            return this.boundsOf((TypeVariable)typeParameter.getBounds()[0]);
        }
        return new TypeVarBoundedType(typeParameter);
    }

    private BoundedType boundsOf(WildcardType wildCard) {
        WildCardBoundedType wildCardBoundedType = new WildCardBoundedType(wildCard);
        if (wildCardBoundedType.firstBound() instanceof TypeVariable) {
            return this.boundsOf((TypeVariable)wildCardBoundedType.firstBound());
        }
        return wildCardBoundedType;
    }

    public abstract Class<?> rawType();

    public List<Type> extraInterfaces() {
        return Collections.emptyList();
    }

    public Class<?>[] rawExtraInterfaces() {
        return new Class[0];
    }

    public boolean hasRawExtraInterfaces() {
        return this.rawExtraInterfaces().length > 0;
    }

    public Map<TypeVariable<?>, Type> actualTypeArguments() {
        TypeVariable<Class<?>>[] typeParameters = this.rawType().getTypeParameters();
        LinkedHashMap actualTypeArguments = new LinkedHashMap();
        for (TypeVariable<Class<?>> typeParameter : typeParameters) {
            Type actualType = this.getActualTypeArgumentFor(typeParameter);
            actualTypeArguments.put(typeParameter, actualType);
        }
        return actualTypeArguments;
    }

    protected Type getActualTypeArgumentFor(TypeVariable<?> typeParameter) {
        Type type = this.contextualActualTypeParameters.get(typeParameter);
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return this.getActualTypeArgumentFor(typeVariable);
        }
        return type;
    }

    public GenericMetadataSupport resolveGenericReturnType(Method method) {
        Type genericReturnType = method.getGenericReturnType();
        int arity = 0;
        while (genericReturnType instanceof GenericArrayType) {
            ++arity;
            genericReturnType = ((GenericArrayType)genericReturnType).getGenericComponentType();
        }
        GenericMetadataSupport genericMetadataSupport = this.resolveGenericType(genericReturnType, method);
        if (arity == 0) {
            return genericMetadataSupport;
        }
        return new GenericArrayReturnType(genericMetadataSupport, arity);
    }

    private GenericMetadataSupport resolveGenericType(Type type, Method method) {
        if (type instanceof Class) {
            return new NotGenericReturnTypeSupport(this, type);
        }
        if (type instanceof ParameterizedType) {
            return new ParameterizedReturnType(this, method.getTypeParameters(), (ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            return new TypeVariableReturnType(this, method.getTypeParameters(), (TypeVariable)type);
        }
        throw new MockitoException("Ouch, it shouldn't happen, type '" + type.getClass().getCanonicalName() + "' on method : '" + method.toGenericString() + "' is not supported : " + type);
    }

    public static GenericMetadataSupport inferFrom(Type type) {
        Checks.checkNotNull(type, "type");
        if (type instanceof Class) {
            return new FromClassGenericMetadataSupport((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return new FromParameterizedTypeGenericMetadataSupport((ParameterizedType)type);
        }
        throw new MockitoException("Type meta-data for this Type (" + type.getClass().getCanonicalName() + ") is not supported : " + type);
    }

    public static class WildCardBoundedType
    implements BoundedType {
        private final WildcardType wildcard;

        public WildCardBoundedType(WildcardType wildcard) {
            this.wildcard = wildcard;
        }

        @Override
        public Type firstBound() {
            Type[] lowerBounds = this.wildcard.getLowerBounds();
            Type[] upperBounds = this.wildcard.getUpperBounds();
            return lowerBounds.length != 0 ? lowerBounds[0] : upperBounds[0];
        }

        @Override
        public Type[] interfaceBounds() {
            return new Type[0];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.wildcard.equals(((TypeVarBoundedType)o).typeVariable);
        }

        public int hashCode() {
            return this.wildcard.hashCode();
        }

        public String toString() {
            return "{firstBound=" + this.firstBound() + ", interfaceBounds=[]}";
        }

        public WildcardType wildCard() {
            return this.wildcard;
        }
    }

    public static class TypeVarBoundedType
    implements BoundedType {
        private final TypeVariable<?> typeVariable;

        public TypeVarBoundedType(TypeVariable<?> typeVariable) {
            this.typeVariable = typeVariable;
        }

        @Override
        public Type firstBound() {
            return this.typeVariable.getBounds()[0];
        }

        @Override
        public Type[] interfaceBounds() {
            Type[] interfaceBounds = new Type[this.typeVariable.getBounds().length - 1];
            System.arraycopy(this.typeVariable.getBounds(), 1, interfaceBounds, 0, this.typeVariable.getBounds().length - 1);
            return interfaceBounds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.typeVariable.equals(((TypeVarBoundedType)o).typeVariable);
        }

        public int hashCode() {
            return this.typeVariable.hashCode();
        }

        public String toString() {
            return "{firstBound=" + this.firstBound() + ", interfaceBounds=" + Arrays.deepToString(this.interfaceBounds()) + '}';
        }

        public TypeVariable<?> typeVariable() {
            return this.typeVariable;
        }
    }

    public static interface BoundedType
    extends Type {
        public Type firstBound();

        public Type[] interfaceBounds();
    }

    private static class NotGenericReturnTypeSupport
    extends GenericMetadataSupport {
        private final Class<?> returnType;

        public NotGenericReturnTypeSupport(GenericMetadataSupport source, Type genericReturnType) {
            this.returnType = (Class)genericReturnType;
            this.contextualActualTypeParameters = source.contextualActualTypeParameters;
            this.registerAllTypeVariables(this.returnType);
        }

        @Override
        public Class<?> rawType() {
            return this.returnType;
        }
    }

    private static class GenericArrayReturnType
    extends GenericMetadataSupport {
        private final GenericMetadataSupport genericArrayType;
        private final int arity;

        public GenericArrayReturnType(GenericMetadataSupport genericArrayType, int arity) {
            this.genericArrayType = genericArrayType;
            this.arity = arity;
        }

        @Override
        public Class<?> rawType() {
            Class<?> rawComponentType = this.genericArrayType.rawType();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append("[");
            }
            try {
                return Class.forName(stringBuilder.append("L").append(rawComponentType.getName()).append(";").toString(), false, rawComponentType.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("This was not supposed to happend", e);
            }
        }
    }

    private static class TypeVariableReturnType
    extends GenericMetadataSupport {
        private final TypeVariable<?> typeVariable;
        private final TypeVariable<?>[] typeParameters;
        private Class<?> rawType;
        private List<Type> extraInterfaces;

        public TypeVariableReturnType(GenericMetadataSupport source, TypeVariable<?>[] typeParameters, TypeVariable<?> typeVariable) {
            this.typeParameters = typeParameters;
            this.typeVariable = typeVariable;
            this.contextualActualTypeParameters = source.contextualActualTypeParameters;
            this.readTypeParameters();
            this.readTypeVariables();
        }

        private void readTypeParameters() {
            this.registerTypeParametersOn(this.typeParameters);
        }

        private void readTypeVariables() {
            for (Type type : this.typeVariable.getBounds()) {
                this.registerTypeVariablesOn(type);
            }
            this.registerTypeParametersOn(new TypeVariable[]{this.typeVariable});
            this.registerTypeVariablesOn(this.getActualTypeArgumentFor(this.typeVariable));
        }

        @Override
        public Class<?> rawType() {
            if (this.rawType == null) {
                this.rawType = this.extractRawTypeOf(this.typeVariable);
            }
            return this.rawType;
        }

        @Override
        public List<Type> extraInterfaces() {
            if (this.extraInterfaces != null) {
                return this.extraInterfaces;
            }
            Type type = this.extractActualBoundedTypeOf(this.typeVariable);
            if (type instanceof BoundedType) {
                this.extraInterfaces = Arrays.asList(((BoundedType)type).interfaceBounds());
                return this.extraInterfaces;
            }
            if (type instanceof ParameterizedType) {
                this.extraInterfaces = Collections.singletonList(type);
                return this.extraInterfaces;
            }
            if (type instanceof Class) {
                this.extraInterfaces = Collections.emptyList();
                return this.extraInterfaces;
            }
            throw new MockitoException("Cannot extract extra-interfaces from '" + this.typeVariable + "' : '" + type + "'");
        }

        @Override
        public Class<?>[] rawExtraInterfaces() {
            List<Type> extraInterfaces = this.extraInterfaces();
            ArrayList rawExtraInterfaces = new ArrayList();
            for (Type extraInterface : extraInterfaces) {
                Class<?> rawInterface = this.extractRawTypeOf(extraInterface);
                if (this.rawType().equals(rawInterface)) continue;
                rawExtraInterfaces.add(rawInterface);
            }
            return rawExtraInterfaces.toArray(new Class[rawExtraInterfaces.size()]);
        }

        private Type extractActualBoundedTypeOf(Type type) {
            if (type instanceof TypeVariable) {
                return this.extractActualBoundedTypeOf((Type)this.contextualActualTypeParameters.get(type));
            }
            if (type instanceof BoundedType) {
                Type actualFirstBound = this.extractActualBoundedTypeOf(((BoundedType)type).firstBound());
                if (!(actualFirstBound instanceof BoundedType)) {
                    return type;
                }
                return actualFirstBound;
            }
            return type;
        }
    }

    private static class ParameterizedReturnType
    extends GenericMetadataSupport {
        private final ParameterizedType parameterizedType;
        private final TypeVariable<?>[] typeParameters;

        public ParameterizedReturnType(GenericMetadataSupport source, TypeVariable<?>[] typeParameters, ParameterizedType parameterizedType) {
            this.parameterizedType = parameterizedType;
            this.typeParameters = typeParameters;
            this.contextualActualTypeParameters = source.contextualActualTypeParameters;
            this.readTypeParameters();
            this.readTypeVariables();
        }

        private void readTypeParameters() {
            this.registerTypeParametersOn(this.typeParameters);
        }

        private void readTypeVariables() {
            this.registerTypeVariablesOn(this.parameterizedType);
        }

        @Override
        public Class<?> rawType() {
            return (Class)this.parameterizedType.getRawType();
        }
    }

    private static class FromParameterizedTypeGenericMetadataSupport
    extends GenericMetadataSupport {
        private final ParameterizedType parameterizedType;

        public FromParameterizedTypeGenericMetadataSupport(ParameterizedType parameterizedType) {
            this.parameterizedType = parameterizedType;
            this.readActualTypeParameters();
        }

        private void readActualTypeParameters() {
            this.registerAllTypeVariables(this.parameterizedType);
        }

        @Override
        public Class<?> rawType() {
            return (Class)this.parameterizedType.getRawType();
        }
    }

    private static class FromClassGenericMetadataSupport
    extends GenericMetadataSupport {
        private final Class<?> clazz;

        public FromClassGenericMetadataSupport(Class<?> clazz) {
            this.clazz = clazz;
            this.registerTypeParametersOn(clazz.getTypeParameters());
            this.registerAllTypeVariables(clazz);
        }

        @Override
        public Class<?> rawType() {
            return this.clazz;
        }
    }
}

