/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.verification;

import com.appland.shade.org.mockito.exceptions.base.MockitoException;
import com.appland.shade.org.mockito.internal.verification.VerificationModeFactory;
import com.appland.shade.org.mockito.internal.verification.api.VerificationData;
import com.appland.shade.org.mockito.internal.verification.api.VerificationDataInOrder;
import com.appland.shade.org.mockito.internal.verification.api.VerificationInOrderMode;
import com.appland.shade.org.mockito.internal.verification.checkers.MissingInvocationChecker;
import com.appland.shade.org.mockito.internal.verification.checkers.NumberOfInvocationsChecker;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.MatchableInvocation;
import com.appland.shade.org.mockito.verification.VerificationMode;
import java.util.List;

public class Calls
implements VerificationMode,
VerificationInOrderMode {
    final int wantedCount;

    public Calls(int wantedNumberOfInvocations) {
        if (wantedNumberOfInvocations <= 0) {
            throw new MockitoException("Negative and zero values are not allowed here");
        }
        this.wantedCount = wantedNumberOfInvocations;
    }

    @Override
    public void verify(VerificationData data) {
        throw new MockitoException("calls is only intended to work with InOrder");
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder data) {
        List<Invocation> allInvocations = data.getAllInvocations();
        MatchableInvocation wanted = data.getWanted();
        MissingInvocationChecker.checkMissingInvocation(allInvocations, wanted, data.getOrderingContext());
        NumberOfInvocationsChecker.checkNumberOfInvocationsNonGreedy(allInvocations, wanted, this.wantedCount, data.getOrderingContext());
    }

    public String toString() {
        return "Wanted invocations count (non-greedy): " + this.wantedCount;
    }

    @Override
    public VerificationMode description(String description) {
        return VerificationModeFactory.description(this, description);
    }
}

