/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.verification;

import com.appland.shade.org.mockito.internal.verification.VerificationEventImpl;
import com.appland.shade.org.mockito.internal.verification.VerificationModeFactory;
import com.appland.shade.org.mockito.internal.verification.api.VerificationData;
import com.appland.shade.org.mockito.listeners.VerificationListener;
import com.appland.shade.org.mockito.verification.VerificationEvent;
import com.appland.shade.org.mockito.verification.VerificationMode;
import java.util.Set;

public class MockAwareVerificationMode
implements VerificationMode {
    private final Object mock;
    private final VerificationMode mode;
    private final Set<VerificationListener> listeners;

    public MockAwareVerificationMode(Object mock, VerificationMode mode, Set<VerificationListener> listeners) {
        this.mock = mock;
        this.mode = mode;
        this.listeners = listeners;
    }

    @Override
    public void verify(VerificationData data) {
        try {
            this.mode.verify(data);
            this.notifyListeners(new VerificationEventImpl(this.mock, this.mode, data, null));
        }
        catch (RuntimeException e) {
            this.notifyListeners(new VerificationEventImpl(this.mock, this.mode, data, e));
            throw e;
        }
        catch (Error e) {
            this.notifyListeners(new VerificationEventImpl(this.mock, this.mode, data, e));
            throw e;
        }
    }

    private void notifyListeners(VerificationEvent event) {
        for (VerificationListener listener : this.listeners) {
            listener.onVerification(event);
        }
    }

    public Object getMock() {
        return this.mock;
    }

    @Override
    public VerificationMode description(String description) {
        return VerificationModeFactory.description(this, description);
    }
}

